// ͻ
//    TEST-PROGRAM FOR THE VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C    
// Ķ
//           (C) Detlef Reimers, JUNE 1999, dreimers@aol.com          
// ͼ
#include <vesa.h>

// Ŀ
//  Global variables.                                                 
// 
int b[3][4][2], h, v, o, u, cnum, cpoint;

// Ŀ
//  Global strings.                                                   
// 
char * titl[] =
{
  "ABOUT BEZIER-CURVES",
  "MODE %d: %dx%d",
  "BEZIER FUNDAMENTALS",
  "LIVE BEZIER ANIMATION"
};

char * info[] =
{
  "Bezier curves consist of two parametric cubic equations:",
  "", "", "",
  "The parameter t goes from 0 to 1 as you move along the",
  "curve. This can generate a straight line, a curved line,",
  "a curve with a cusp in it, a curve with an inflection",
  "point or certain curves with simple loops in them.",
  "",
  "In graph space, the cubic spline is defined by four",
  "points: a initial point P0, a end point P3 and the first",
  "and second influence points P1 and P2.",
  "",
  "The influence points determine the slope and the velocity",
  "with which the initial and end point are exited.",
  "",
  "Solving linear equations lets you get from graph space",
  "to the equation space:",
  "", "", "", "", "",
  "You can solve these backwards to get from equation space",
  "to graph space:",
  "", "", "", "", "", "", "",
  "Choose a picture with 1/2/3. Choose the next/last point",
  "with +/-. Now simply move the points with the arrow keys."
};

char * math[] =
{
  "x = at^3 + bt^2 + ct + d",
  "y = et^3 + ft^2 + gt + h",
  "a =  x3 - 3x2 + 3x1 - x0   e =  y3 - 3y2 + 3y1 - y0",
  "b = 3x2 - 6x1 + 3x0        f = 3y2 - 6y1 + 3y0",
  "c = 3x1 - 3x0              g = 3y1 - 3y0",
  "d =  x0                    h =  y0",
  "x0 = d                     y0 = h",
  "x1 = d +  c/3              y1 = h +  g/3",
  "x2 = d + 2c/3 + b/3        y2 = h + 2g/3 + f/3",
  "x3 = d + c + b + a         y3 = h + g + f + e"
};

// Ŀ
//  INITPOINTS: This sets the initial bezier points.                  
// 
void initpoints(void)
{
  b[0][0][0] =   h +  20;   b[0][0][1] =        70;
  b[0][1][0] =   h +  40;   b[0][1][1] =   v +  30;
  b[0][2][0] = hor - 120;   b[0][2][1] =   v +  30;
  b[0][3][0] = hor -  50;   b[0][3][1] =        80;

  b[1][0][0] =   h  + 20;   b[1][0][1] =   v +  90;
  b[1][1][0] =   h  + 40;   b[1][1][1] = 2*v +  50;
  b[1][2][0] = hor -  60;   b[1][2][1] =   v + 100;
  b[1][3][0] = hor - 100;   b[1][3][1] = 2*v +  50;

  b[2][0][0] =   h +  90;   b[2][0][1] = 3*v +  70;
  b[2][1][0] = hor -  50;   b[2][1][1] = 3*v -  60;
  b[2][2][0] =   h +  30;   b[2][2][1] = 3*v -  60;
  b[2][3][0] = hor - 110;   b[2][3][1] = 3*v +  70;
}

// Ŀ
//  SETPOINTS: This sets the clip rectangle and the bezier points.    
// 
void setpoints(int m)
{
  int i, j;

  o = 49 + (m-1) * (20 + v);
  u = 49 + (m-1) * (20 + v) + v;

  for (i = 0; i < 4; i++)
    for (j = 0; j < 4; j++)
      bez[i][j] = b[m-1][i][j];
}

// Ŀ
//  DRAWDOTS: This draws the bezier points and their names.           
// 
void drawdots(int m)
{
  if (m == 0)
  {
    fcircle(bez[0][0], bez[0][1], 2, 16);
    fcircle(bez[1][0], bez[1][1], 2, 16);
    fcircle(bez[2][0], bez[2][1], 2, 16);
    fcircle(bez[3][0], bez[3][1], 2, 16);

    print  (bez[0][0] + 6, bez[0][1] - 2, 16, 16, "P0");
    print  (bez[1][0] + 6, bez[1][1] - 2, 16, 16, "P1");
    print  (bez[2][0] + 6, bez[2][1] - 2, 16, 16, "P2");
    print  (bez[3][0] + 6, bez[3][1] - 2, 16, 16, "P3");
  }
  else
  {
    fcircle(bez[0][0], bez[0][1], 2, yellow);
    fcircle(bez[1][0], bez[1][1], 2, lblue);
    fcircle(bez[2][0], bez[2][1], 2, lblue);
    fcircle(bez[3][0], bez[3][1], 2, yellow);

    print  (bez[0][0] + 6, bez[0][1] - 2, 15, 16, "P0");
    print  (bez[1][0] + 6, bez[1][1] - 2, 15, 16, "P1");
    print  (bez[2][0] + 6, bez[2][1] - 2, 15, 16, "P2");
    print  (bez[3][0] + 6, bez[3][1] - 2, 15, 16, "P3");
  }
}

// Ŀ
//  DRAWHANDLES: This draws the bezier handles.                       
// 
void drawhandles(int c)
{
  line(bez[0][0], bez[0][1], bez[1][0], bez[1][1], c);
  line(bez[2][0], bez[2][1], bez[3][0], bez[3][1], c);
}

// Ŀ
//  MOVE: This moves the choosen control point and redraws the curve. 
// 
void move(int p, int m)
{
  clip(h + 1, o + 1, hor-17, u - 1);

  retrace();
  drawhandles(16);
  bezier(5, 16);
  drawdots(0);

  if (m == 1)
    bez[p][1] = bez[p][1] - 1;

  if (m == 2)
    bez[p][1] = bez[p][1] + 1;

  if (m == 3)
    bez[p][0] = bez[p][0] - 1;

  if (m == 4)
    bez[p][0] = bez[p][0] + 1;

  drawhandles(4);
  bezier(5, lgreen);
  drawdots(1);

  b[cnum][p][0] = bez[p][0];
  b[cnum][p][1] = bez[p][1];
}

// Ŀ
//  SELECT: Mark the selected rectangle and the active point in red.  
// 
void select(int n)
{
  clip(h - 1, o - 1, hor-15, u + 1);
  rect ( h, o, hor-15, u, lwhite);
  
  clip(h + 1, o + 1, hor-17, u - 1);
  drawdots(1);
  cnum = n - 49;
  cpoint = 1;
  setpoints(cnum+1);

  clip(h - 1, o - 1, hor-15, u + 1);
  rect ( h, o, hor-15, u, lred);

  clip(h + 1, o + 1, hor-17, u - 1);
  fcircle(bez[0][0], bez[0][1], 2, lred);
}

// Ŀ
//  CHECK: This checks the curve, point and direction to move.        
// 
void check(int i)
{
  int k;

  if ((i > 48) & (i < 52))
  {
    select(i);
  }
  else
  {
    cpoint = 0;
    check(waitkey());
  }

  while (cpoint != 0)
  {
    k = waitkey();

    if ((k > 48) & (k < 52))
      check(k);
    else if (k == 43)
    {
      cpoint = cpoint + 1;
      if (cpoint > 4)
        cpoint = 1;
      drawdots(1);
      fcircle(bez[cpoint-1][0], bez[cpoint-1][1], 2, lred);
    }
    else if (k == 45)
    {
      cpoint = cpoint - 1;
      if (cpoint < 1)
        cpoint = 4;
      drawdots(1);
      fcircle(bez[cpoint-1][0], bez[cpoint-1][1], 2, lred);
    }
    else if (k == 72)
      move(cpoint-1, 1);
    else if (k == 80)
      move(cpoint-1, 2);
    else if (k == 75)
      move(cpoint-1, 3);
    else if (k == 77)
      move(cpoint-1, 4);
  }
}

// Ŀ
//  SCREEN: Set up a screen with infos, curves and a border.          
// 
void screen(void)
{
  int i, k;

  h = hor / 2 + 115;
  v = (ver - 100) / 3;
  k = hor - 141 - 8*(hor/1000) - 8*(ver/1000);

  setcol(blue, 0, 23, 35);
  setcol(black, 45, 45, 45);
  
  rect (0,  0, hor-1, ver-1, lwhite);
  hline(20, 1, hor-1,        lwhite);
  frect(1,  1, hor-2, 19,    blue);

  print(5,  7, lwhite , 16,  titl[0]);
  print(k,  7, lwhite , 16,  titl[1], mode, hor, ver);

  for (i = 0; i < 3; i++)
  {
    o = 49 + i * (20 + v);
    u = 49 + i * (20 + v) + v;

    print(hor-90, o-10,   yellow, 16, "Picture %d", i+1);
    frect( h, o,  hor-15, u,      16);
    rect ( h, o,  hor-15, u,      lwhite);
    hline(u+1,    h,      hor-14, 16);
    vline(hor-14, o,      u+1,    16);
    initpoints();
    setpoints(i+1);
    drawhandles(4);
    bezier(5, lgreen);
    drawdots(1);
  }

  print( 15,  47,  lwhite, 16, titl[2]);
  hline( 56,  15,  152+15, lwhite);
  hline( 57,  16,  152+16, 16);
  print( 15, 527,  lwhite, 16, titl[3]);
  hline(536,  15,  168+15, lwhite);
  hline(537,  16,  168+16, 16);

  for (i = 0; i < 34; i++)
    print(15, 68 + 15*i, 16, 0, info[i]);

  for (i = 0; i < 2; i++)
    print(127, 90 + 15*i, 1, 0, math[i]);

  for (i = 20; i < 24; i++)
    print(43, 15*i + 45, 1, 0, math[i-18]);

  for (i = 26; i < 30; i++)
    print(35, 15*i + 60, 1, 0, math[i-20]);
}

// Ŀ
//  MAIN: This runs the demo function at several resolutions.         
// 
void main(void)
{
  gmode(259);
  screen();
  check(waitkey());
  tmode();
}

