// ͻ
//    TEST-PROGRAM FOR THE VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C    
// Ķ
//           (C) Detlef Reimers, JUNE 1999, dreimers@aol.com          
// ͼ
#include <vesa.h>

// Ŀ
//  Global variables.                                                 
// 
int dy;

// Ŀ
//  Global strings.                                                   
// 
char * info[5] =
{
  "MODE %d: %dx%d",
  "SHOW ANIMATED OBJECTS",
  "ANIMATION SPEED: %d",
  "VESALIB  ANIMATION",
  "PLEASE, PRESS A KEY..."
};

// Ŀ
//  SCREEN: Set up a screen with infos and a border.                  
// 
void screen(int n)
{
  int h, k, v;

  h = hor / 2;
  v = ver / 2;
  k = hor - 141 - 8*(hor/1000) - 8*(ver/1000);

  if (n == 1)
  {
    setcol(black, 45, 45, 45);
    setcol( blue,  0, 23, 35);

    frect (2, 19, hor - 2, ver - 2, black);
    frect (1,  1, hor - 1, 17, blue);
    rect  (0,  0, hor - 1, ver - 1, lwhite);
    line  (0, 18, hor - 1, 18, lwhite);
    print (k,  6, lwhite, 16, info[0], mode, hor, ver);
    print (5,  6, lwhite, 16, info[1]);
  }
  frect (h - 76, v - 6, h + 74, v + 12, blue);
  rect  (h - 76, v - 6, h + 74, v + 12, lwhite);
  print (h - 72, v, yellow, 16, info[2], dy);

  clip  (2,  19, hor - 2, ver - 2);
}

// Ŀ
//  DRAWBALL: Draw the ball at the position.                          
// 
void drawball(int x, int y)
{
  key();

  fcircle(x  , y  , 15, 40);
  fcircle(x-5, y-5,  5, 12);
  fcircle(x-5, y-5,  4, 64);
  fcircle(x-5, y-5,  3, 86);
  fcircle(x-5, y-5,  1, lwhite);
  
  retrace();
  
  fcircle(x,   y,   15, black);
}

// Ŀ
//  DRAWRECT: Draw the rectangle at the position.                     
// 
void drawrect(int x, int y)
{
  key();

  frect(x - 76, y - 4, x + 74, y + 10, blue);
  hline(y + 11, x - 75, x + 75, 16);
  vline(x + 75, y - 3, y + 11, 16);
  print(x - 72, y, lwhite, 0, info[3]);
  
  retrace();
  
  frect(x - 76, y - 4, x + 75, y + 11 + dy, black);
}

// Ŀ
//  DEMO: This function moves some text from bottom to top.           
//        Always do the retrace just before whiping out the previous  
//        drawn picture. This will give best results for animation.   
// 
void demo(int m)
{
  int i, h, v;

  gmode(m);
  screen(1);

  h  = hor / 2;
  v  = ver / 2;

  for (dy = 2; dy < 7; dy++)
  {
    screen(0);

    for (i = ver + 20; i > v + 28 ; i -= dy)
      drawball(h, i);

    for (i = h; i < h + 90 ; i += dy)
      drawball(i, v + 28);

    for (i = v + 28; i > v - 22 ; i -= dy)
      drawball(h + 90, i);

    for (i = h + 90; i > h ; i -= dy)
      drawball(i, v - 22);

    for (i = v - 22; i > 0 ; i -= dy)
      drawball(h, i);

    for (i = ver + 20; i > 0 ; i -= dy)
      drawrect(h, i);
  }
  print(h - 84, v, 44, 16, info[4]);
  
  waitkey();
}

// Ŀ
//  MAIN: It runs the demo function at several resolutions.           
// 
void main(void)
{
  demo(257);
  demo(259);
  demo(261);

  tmode();
}

