/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: MSGEXIT.C $
   $Locker: ska $	$Name:  $	$State: Rel $

   Shutdown the MSGLIB.
   Each method's msg?Init() function can register a function to be
   executed in conjunction with all the other subsystem's shutdown
   functions

*/
#include "yerror.h"


#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: MSGEXIT.C 1.2 1998/10/07 04:42:53 ska Rel ska $";
#endif /*#	defined(RCS_Version) */



/*
 * defines a function, which is executed right before exit(),
 * in the case an error() or fatal() message has been emitted
 */
#ifdef _MICROC_
static int exitFunc = 0;
void _msgExitFunc(int fct)

#else /*#	!(defined(_MICROC_)) */
static void (*exitFunc)(void) = 0;
void msgExitFunc(void (*fct)(void))

#endif /*#	defined(_MICROC_) */

{	exitFunc = fct; }


void msgExit(void)
{
	if(exitFunc)
		(exitFunc)();
	msgExitMV();
	msgExitMI();
}
