/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: MSG2READ.C $
   $Locker: ska $	$Name:  $	$State: Rel $

	int msgRereadCats(void)

	Reread all catalogues, thus, applying the latest changes wihtin the
	environment. The former associations between the message groups are
	kept intact, however, their strength is reverted to (not higher than)
	STR_CHARSET.

	Return:
		The summary of all msgDatabase() functions

*/

#include <assert.h>
#include <portable.h>
#include "msg2.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: MSG2READ.C 1.3 1998/10/07 04:42:53 ska Rel ska $";
#endif /*#	defined(RCS_Version) */

int msgRereadCats(void)
{	msgGrpDef *grp;
	int i, cnt, j;
	MsgCatFile *cf;
	MSGFILE fd;

	/* Revert the strengths of the already installed message groups */
	IF_GCAT {
		grp = GCAT groups;
		for(i = MSGGROUPMAX; i--; sInc(grp))
			if(grp->strength > STR_CHARSET)
				grp->strength = STR_CHARSET;
	}

#ifdef MSG_SINGLE_CATALOGUE_FILE
	/* We only have the standard catalogues */
	return msg2StdCats();
#else /*#	!(defined(MSG_SINGLE_CATALOGUE_FILE)) */
	/* The catalogues are saved within the msg_catalogues chain;
		just read all databases noted there */

	/* If msg_catalogues enumerates at least one entry, msg2Database()
		had been successfully called at least once. That means that
		the global catalogue buffer is available */
#ifdef MSG_MULTIPLE_CATALOGUES
	assert(msg_glbCat);
#endif

	cnt = i = 0;		/* counter and negative sign */
	if((cf = msg_catalogues.head) != NULL) do {
		if((fd = cf->fd) != MSGNOFILE
		 || (fd = msg2OpenCat(cf->fnam)) == MSGNOFILE) {
			if((j = msg2ScanLngDefs(PAS_GCAT fd, cf->pos, cf->limit)) < 0)
				i = 1, j = -j;	/* preserve the "error" indicator */
			cnt += j;
			if(cf->fd == MSGNOFILE)
				msg2CloseCat(fd);
		}
	} while((cf = cf->nxt) != NULL);

	return i? -cnt: cnt;
#endif /*#	defined(MSG_SINGLE_CATALOGUE_FILE) */
}
