/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: MSG2GET.C $
   $Locker: ska $	$Name:  $	$State: Rel $

	MsgStr *msg2Get(DCL_GCAT MSGID2 id)

	Fetch message with the id from the catalogue

	Return:
		NULL: message not found / error accessing catalogue file
		else: pointer to cached message

*/

#include <assert.h>
#include <stdlib.h>

#include "msg2.h"
#include "fileIO.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: MSG2GET.C 1.3 1998/10/07 04:42:53 ska Rel ska $";
#endif /*#	defined(RCS_Version) */

MsgStr *msg2Get(DCL_GCAT MSGID2 id)
{	MsgStru3 msg3;
	msgGrpDef *gr;
	MsgStr *str;
	int idx;

	gr = aS(GCAT groups[msgGroup(id)]);
	idx = msgIndex(id);

	if(!gr || idx == 0 || gr->entries < idx)
		return NULL;		/* invalid index */

	/* search the already cached messages for this message */
	if((str = msg2Find(GCAT strings, id, NULL, NULL)) != NULL) {
		if(++str->links > 0)	/* found */
			return str;

		/* overflow of 'links' member */

		/* We could generate a second entry, however, this means two
			things:
			+ 65535 times of the same locked entry?! It should be some
				kind of problem, doesn't it?
			+ Two entries of the same msgID would mean that we does not
				know in a msg2Unlock() call, which string will be unlocked.
		*/
		--str->links;		/* Make the member a valid value */
		return NULL;		/* pretend some kind of error */
	}

	/* add a new message, try to read in the stru3 to get knowledge
		about the length of the message text */
	if(!Mseek3(gr->file, gr->pos, idx)
	 || !MSread(gr->file, msg3)
	 || !Mseekr(gr->file, msg3.ms3_string)
	 || (str = malloc(sizeof(MsgStr) + msg3.ms3_length)) == NULL)
	 	return NULL;		/* catalogue access / out-of-mem error */

	if(!Mread(gr->file, str->text, msg3.ms3_length)) {
		free(str);
		return NULL;
	}

	/* fill the values from stru3 to be available */
	str->text[msg3.ms3_length] = '\0';	/* security '\0', space avail */
	str->exitcode = msg3.ms3_exitcode;
	str->msgclass = msg3.ms3_class;
	str->id = id;
	str->links = 1;

	/* join into chain */
	str->nxt = GCAT strings;
	GCAT strings = str;

	return str;
}
