/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $Id: MCVARARG.H 1.4 1998/10/07 04:42:53 ska Rel ska $
   $Locker: ska $	$Name:  $	$State: Rel $

	Micro-C <stdarg.h> substitute and portability stuff for non-Micro-C.

	A variable definition of the ANSI style must be written as:
		VARIANT(<type> <function>,<argument>)
		{	<variable definitions>
			VARIANTINIT(<variable>, <argument>)
		}

   	Note: The way variable arguments are handled by Micro-C requires
   	that 1) the variable pointer is initialized immediately following
   	the definition of the variables,& 2) the function has exactly one
   	argument.

*/

#ifndef __MCSTDARG_H
#define __MCSTDARG_H

#ifdef _MICROC_

#define VARIANT(fct,arg) register fct(arg)
#define VARIANTINIT(var,arg) unsigned *var; var = nargs() * 2 + &arg;
#define va_arg(var,type) ((var -= 2), (type)*var)
#define va_end(var)

#else /*#	!(defined(_MICROC_)) */

#include <stdarg.h>

#define VARIANT(fct,arg) fct(arg, ...)
#define VARIANTINIT(var,arg) va_list var; va_start(var, arg);

#endif /*#	defined(_MICROC_) */

#endif /*#	!defined(__MCSTDARG_H) */
