/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: HP-CATS.C $
   $Locker: ska $	$Name:  $	$State: Rel $

	Implementation of the HP-like catalogue functions.

	Note: If MSG_MULTIPLE_CATALOGUES is not #define'ed, catopen()
		will always work over the global catalogue, as msgCatalogue().

*/

#ifndef _MICROC_
#include <stdlib.h>
#endif

#include "msg2.h"
#include "nl_types.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: HP-CATS.C 1.3 1998/10/07 04:42:53 ska Rel ska $";
#endif

/* Opens a new catalogue.
	'flag' is ignored.
	'name' is first tried as an external file.
	_Currently_ the catalogue files are not searched for.

	Return:
		-1: error
		else: catalogue descriptor
*/
nl_catd catopen(char *fnam, int flag)
{
#ifdef MSG_MULTIPLE_CATALOGUES 
	/* Every catopen() call generates its own catalogue buffer */

	dword pos, limit;	/* start & end of item chain within catalogue */
	MSGFILE fd;
	msgCat *msg_glbCat;
	int rv;

	msg2InitX();		/* Initialize the MR subsystem */

	if((msg_glbCat = msg_mkCatBuf()) == NULL)
		return (nl_catd)(-1);

	if((fd = msgIdentCat(fnam, aS(pos), aS(limit))) != MSGNOFILE) {
		/* valid catalogue file */
		rv = msg2ScanLngDefs(PAS_GCAT fd, pos, limit);
		msg2CloseCat(fd);
		if(rv > 0)
			/* OK, at least one language definition found */
			/* That means that we have found something as well */
			return (nl_catd)msg_glbCat;
	}

	/* Some error occured */
	free(msg_glbCat);

	return (nl_catd)(-1);

#else
	/* Only the global catalogue is available --> we can use msgDatabase()
	*/

	msg2InitX();		/* Initialize the MR subsystem */

	return (msgCatalogue(fnam) > 0)
	 ? (nl_catd)(aS(msg_glbCat))
	 : (nl_catd)(-1);
#endif
}

/* Close the catalogue
*/
void catclose(nl_catd Xcat)
{	
#ifdef MSG_MULTIPLE_CATALOGUES 
	msgCat *cat;
	int i;

	if((cat = Xcat) != NULL) {
		i = MSGGROUPMAX;
		while(i--)
			msg2CloseCat(cat->groups[i].file);
		msg2StrClear(&cat->strings);
		free(cat);
	}

/*	#else
		with the global catalogue only, nothing can be undone */
#endif
}

/* Reads message number 'message_number' of set number 'set_number'
	from the opened catalogue.

	Note: catgets() will return 'message' in every case, the
		message could not be retrieved.

	Return:
		message: If catalogue or message is not available
		else: internal buffer of loaded message
*/
char *catgets(nl_catd catalog, int set_number, int msg_number
	, char *message)
{
	char *str;
#ifdef MSG_MULTIPLE_CATALOGUES 
	msgCat *msg_glbCat;

	msg_glbCat = catalog;
#endif

	IF_GCAT if((unsigned)set_number <= NL_SETMAX
	 && (unsigned)msg_number <= NL_MSGMAX
	 // && set_number		/* this is confusing --> treat 0 == 16 */
	 && msg_number
	 && (str = msg2Rtrv_(PAS_GCAT mkMsgID(set_number, msg_number))) != NULL
	 && GCAT lastRetrieve)		/* msg2Retrieve() returned default msg */
		return str;
	return message;		/* some error occured */
}
