/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $Id: FILEIO.H 1.3 1998/10/07 04:42:53 ska Rel ska $
   $Locker: ska $	$Name:  $	$State: Rel $

	File IO declarations.

*/

#ifndef __FILEIO_H
#define __FILEIO_H

#include <io.h>
#include "msgconf2.h"

/*
 *	Read a sequence of bytes from a file, handle all side-effects.
 *	In DOS EINTR has no real meaning, so implementation is simple.
 *	Return: 0 on failure
 */
#define Mread(f,buf,len)	\
	(read((f), (buf), (len)) == (len))

/*
 *	Read one structure from the file
 *	Return: 0 on failure
 */
#define MSread(f,obj)	\
	Mread((f), aS(obj), sizeof(obj))

/*
 *	Read one object from the file
 *	Return: 0 on failure
 */
#define MOread(f,obj)	\
	Mread((f), &(obj), sizeof(obj))

/*
 *	Read one pointed object from the file
 *	Return: 0 on failure
 */
#define MPread(f,pobj)	\
	Mread((f), (pobj), sizeof(*pobj))



/*
 *	Get/Set the absolute file position
 *	Return: 0 on failure
 */
#ifdef _MICROC_
#define Mgetpos(f,pos)	\
	(ltell((f), &(pos)->hi, &(pos)->lo) == 0)
#define Msetpos(f,pos)	\
	(lseek((f), (pos)->hi, (pos)->lo, 0) == 0)
#else /*#	!(defined(_MICROC_)) */
#define Mgetpos(f,pos)	\
	(((pos) = tell((f))) != (dword)-1)
#define Msetpos(f,pos)	\
	((dword)lseek((f), (pos), SEEK_SET) == (pos))
#endif /*#	defined(_MICROC_) */

/*
 *	Seek file positions
 *
 *	Mseek(): seek an (int) displacement relative to the current position
 *	Mseekr(): seek relatively by a (dword) displacement
 *	Mseek3(): seek to idx'th entry of msg3 array at absolute 'base'
 *		idx == 1 is the very first message of the group
 *	Mseeke(): seek to end of file
 *	Mseekb(): seek to begin of file
 *
 *	Return:	0 on failure
 */
#ifdef _MICROC_
int Mseek(MSGFILE f, int ofs);
int Mseekr(MSGFILE f, dword *ofs);
int Mseek3(MSGFILE f, dword *base, unsigned idx);
#define Mseeke(f)	(lseek((f), 0,0, 2) == 0)
#define Mseekb(f)	(lseek((f), 0,0, 0) == 0)
#else /*#	!(defined(_MICROC_)) */
#define Mseek(f,ofs)	(lseek((f), (int)(ofs), SEEK_CUR) != -1)
#define Mseekr(f,ofs)	(lseek((f), (ofs), SEEK_CUR) != -1)
#define Mseek3(f,base,idx)	(lseek((f)		\
	, (dword)(base) + ((word)((idx) - 1) * sizeof(MsgStru3)), SEEK_SET) != -1)
#define Mseeke(f)	(lseek((f), 0, SEEK_END) != -1)
#define Mseekb(f)	(lseek((f), 0, SEEK_SET) == 0)
#endif /*#	defined(_MICROC_) */

#endif /*#	!defined(__FILEIO_H) */
