/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*
    HASHFILE - Management of temporary files
    Copyright (C) 1998  Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
*/
/* $RCSfile: HASHFILE.H $
   $Locker: ska $	$Name:  $	$State: Exp $

	Handling of temporary hash files, based on "tmpFile".

	HashFile *hashFile(void)
		Create a temporary file for hashing, it's always opened
		in TF_RW, but set to TF_RD on return.

	void clHashFile(HashFile *f)
		Close an hash file.

	void hfseek(unsigned index, HashFile *f)
		Seek to the index'th (dword) entry of f.

	void hfread(unsigned idx, dword pos, HashFile *f)
		Read the idx'th (dword) entry from the hash file.
		aS() is automatically applied to pos.

	void hfwrite(unsigned idx, dword pos, HashFile *f)
		Write the idx'th (dword) entry into the hash file.
		aS() is automatically applied to pos.

	void hfrewrite(dword pos, HashFile *f)
		Rewrite the entry immediately before the current position of f.
		Used to overwrite the previouslt read entry.

   ----

   Target compilers:
   		Micro-C v3.14, Borland C++ v3.1+

   ----
	
	Known bugs:

   ----
	
*/

#ifndef __HASHFILE__H_
#define __HASHFILE__H_

struct HashFile_ {
	FILE *fp;
	char *fn;			/* name of that file */
	unsigned entries;
};
#ifdef _MICROC_
#define HashFile struct HashFile_
#else /*#	!(defined(_MICROC_)) */
typedef struct HashFile_ HashFile;
#endif /*#	defined(_MICROC_) */


extern HashFile *hashFile(void);
#define clHashFile(f) clTempFile( cS(TempFile *) f)
void hfseek(unsigned index, HashFile *f);
#define hfread(idx,pos,hashfile) hfread_(idx, aS(pos), hashfile)
void hfread_(unsigned idx, dword nM(*) pos, HashFile *f);
void hfwrite(unsigned idx, dword pos, HashFile *f);
void hfrewrite(dword pos, HashFile *f);

#endif /*#	!defined(__HASHFILE__H_) */
