/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*
    HASHFILE - Management of temporary hash files
    Copyright (C) 1998  Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
*/
/* $RCSfile: HASHFILE.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	Handling of temporary hash files, based on "tmpFile".

   ----

   Target compilers:
   		Micro-C v3.14, Borland C++ v3.1+

   ----
	
	Known bugs:

   ----
	
*/

#include <assert.h>
#include <stdio.h>
#ifndef _MICROC_
#include <limits.h>
#include <stdlib.h>
#include <string.h>
#endif /*#	!defined(_MICROC_) */
#include <portable.h>

#include "savemem.h"
#include "fileIO.h"
#include "shStr.h"
#include "tmpFile.h"
#include "hashFile.h"

#ifdef __TURBOC__
#pragma hdrstop
#endif /*#	defined(__TURBOC__) */

#include "yerror.h"


#ifndef NUL
#define NUL '\0'
#endif /*#	!defined(NUL) */


#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: HASHFILE.C 2.3 1998/10/04 05:17:36 ska Exp ska $";
#endif /*#	defined(RCS_Version) */


/*
 *	Create an hash file
 */
HashFile *hashFile(void)
{	HashFile *f;

	f = cS(HashFile*) tmpFile(TF_RW);

	assert(f);

	f = chgmem(f, sizeof(*f));	/* the 'entries' field is missing! */
	f->entries = 0;
	setMode(f->fp, TF_RD);

	return f;
}


/*
 *	Seek to the index'th slot of the hash table
 *	The 'index' is currently the length of the message
 *	The hash file consists of one (dword) entry per index.
 */
void hfseek(unsigned index, HashFile *f)
{	dword pos;

	assert(f);

	if(index >= f->entries) {		/* need to expand the file */
		/* we must clear the positions we are currently not using
			because they might be read later */
		Eseek(0, SEEK_END, f->fp, f->fn);
		longset(pos, 0);
		setMode(f->fp, TF_WR);
		do Ewrite(aS(pos), sizeof(pos), f->fp, f->fn);
		while(index >= ++f->entries);
		setMode(f->fp, TF_RD);
	}


#ifdef _MICROC_
	/* because sizeof(dword) == 4
			==>
		pos := (index << 1) << 1;
	*/
	longset(pos, index);
	longshl(pos);
	longshl(pos);
	Esetpos(pos, f->fp, f->fn);
#else /*#	!(defined(_MICROC_)) */
	Esetpos((long)index * sizeof(dword), f->fp, f->fn);
#endif /*#	defined(_MICROC_) */
}

/*
 *	Read a specific entry from an hash file
 */
void hfread_(unsigned idx, dword nM(*) pos, HashFile *f)
{	
	assert(f);
	assert(pos);

	hfseek(idx, f);
	Eread(pos, sizeof(dword), f->fp, f->fn);
}

/*
 *	Write a specific entry from an hash file
 */
void hfwrite(unsigned idx, dword iM(*) pos, HashFile *f)
{	
	assert(f);

	hfseek(idx, f);
	Ewrite(aS(pos), sizeof(dword), f->fp, f->fn);
}

/*
 *	Rewrite (overwrite) the last index
 */
void hfrewrite(dword iM(*) pos, HashFile *f)
{	
	assert(f);

	Eseek(-sizeof(dword), SEEK_CUR, f->fp, f->fn);
	setMode(f->fp, TF_WR);
	Ewrite(aS(pos), sizeof(dword), f->fp, f->fn);
	setMode(f->fp, TF_RD);
}


