/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*
    COPYF - File copy functions
    Copyright (C) 1998  Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
*/
/* $RCSfile: COPYF.H $
   $Locker: ska $	$Name:  $	$State: Exp $

	File copy functions using the "fileIO.h" functions.
	These functions use the "fileIO.h" functions and issue an error message
	on failue and terminate the program.

	void copyfile(unsigned size, FILE *toFp, char *toFn, FILE *frFp, char *frFn)
		Copy the contents of the file "frFp" --> "toFp".
		Only an (int) length.

	void copyfilel(dword iM(*) size, FILE *toFp, char *toFn, FILE *frFp, char *frFn)
		Copy the contents of the file "frFp" --> "toFp".
		'size' requires no aS().

	void copyfilee(FILE *toFp, char *toFn, FILE *frFp, char *frFn)
		Copy "frFp" --> "toFp" to the end of "frFp".

   ----

   Target compilers:
   		Micro-C v3.14, Borland C++ v3.1+

   ----
	
   Known bugs:

   ----
	
*/



#ifndef __COPYF__H_
#define __COPYF__H_

#define COPYBUF 1024	/* size of the buffer malloc()'ed to buffer the
							copy process */

extern void copyfile(unsigned size, FILE *toFp, char *toFn, FILE *frFp, char *frFn);
extern void copyfilel(dword iM(*) size, FILE *toFp, char *toFn, FILE *frFp, char *frFn);
extern void copyfilee(FILE *toFp, char *toFn, FILE *frFp, char *frFn);


#endif /*#	!defined(__COPYF__H_) */
