/* $Id: FMEMORY.H 2.2 1998/08/05 09:42:22 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	Far memory handling function.

	The implementation contains each string and memory function with
	a prepended "_f", e.g.: "strlen" -> "_fstrlen",& "memcmp" -> "_fmemcmp".

	The far pointers are given by two arguments instead of only one, e.g.:
		"strlen(str)" -> "_fstrlen(strSegment, strOffset)"
		"memcpy(d,s,l)" -> "_fmemcpy(dSeg, dOfs, sSeg, sOfs, l)"
	Because of this, the implementation does NOT completely covers far
	memory handling, because there is no way for real far variables.

	The implementation is a FAR implementation, not a HUGE one. That means,
	that no check is performed, if the segment will be wrapped.

	Two defines can help to increase the compatibly with other compilers:
		MK_FP(seg, ofs) simply replaces its arguments and the comma and,
			therefore, can be used in the argument list of "_f" functions
			quite easily, e.g.:
				"_fstrlen(MK_FP(seg, ofs))" expands to:
				"_fstrlen((seg), (ofs))".
			The macro fails, if far pointer arethmetics will be made.
		TO_FP(var) casts the variable to a far pointer and expands to:
			get_ds(), (var)
			So it can also be used in the argument list replacing the far
			pointer casting, eg.:
				char *dstr;
				_fstrcpy((char far*)dstr, sstr)
			->
				char *dstr;
				_fstrcpy(TO_FP(dstr), sstr)
			In non-Micro-C mode, this expands to:
				_fstrcpy(((void far*)(dstr)), sstr)
			In Micro-C mode, this expands to:
				_fstrcpy(get_ds(), (dstr), sstr)

   $Log: FMEMORY.H $
   Revision 2.2  1998/08/05 09:42:22  ska
   Release Version 2.5:

   chg: getopt() to not depend on msglib
   add: portable.h: getvect(), setvect(), isr
   chg: moving _f*() memory/string function declarations into fmemory.h
   bugfix: env_size.c: env_newsize(): shrinking causes unpredictable results
   add: _fmemcmp(), _fnormalize(), _fmemmove() for PAC
   add: dta.c/suppl.h: setdta()/getdta()
   add: suppl.h/filefind.c: findfirst()/findnext()/ffblk for PAC
   add: _getdcwd.c: Pacific C version
   add: suppl.h: settings for Pacific C, incl. (struct REGPACK)
   chg: all *.c files include INITSUPL.INC as the very first
   	line after the welcome header. This will setup various
   	compiler depend macros (e.g. _PAC_NOCLIB_)
   add: setdisk.c, getdisk.c, osvers.c: for Pacific C
   add: portable.h: various settings: Support for Pacific C v7.51

   Revision 2.1  1996/11/08 03:18:16  ska
   chg: Makefile: automatically detect, when switching compiler or mem model etc.
   fix: mcb_walk: evaluating _FLAGS after destroying them by a compare
   add: env_noSpace: check if environment can hold another variable
   fix: env_change: don't delete the variable if environment too small
   fix: env_strput: check env size, f a new string is appended
   chg: environ.h: prototype: putenv(char *var) to conform to DOS quasi-standard

   Revision 2.0  1996/08/01 08:22:35  ska
   Release Version 2

   Target compilers: Micro-C, Borland C v2.0, v3.1, v4.52

   Revision 1.3  1996/07/29 06:53:45  ska
   add: DOSalloc(), addu()
   chg: newenv(), sizenv()

   Revision 1.2  1996/07/25 06:34:48  ska
   fix: (signed) cast bug in suppl.h

   Revision 1.1  1996/05/19 03:43:03  ska
   Initial revision

*/

#ifndef __FMEMORY_H
#define __FMEMORY_H

#ifdef _MICROC_				/* for use for Micro-C only */

#define MK_FP(seg,ofs) (seg), (ofs)
#define TO_FP(var) get_ds(), (var)
#define _fnormalize(seg,ofs) _fnormalize_(&(seg), &(ofs))

#endif

#ifdef _PAC_NOCLIB_
#include <stdlib.h>
#define _fmemcpy farmemcpy
#define _fmemset farmemset

extern int _fstrlen(void far * const s);
extern void _fmemmove(void far * const dst, const void far * const src, unsigned length);
extern int _fmemcmp(const void far * const dst, const void far * const src, unsigned length);

#endif

#ifndef _MICROC_
#ifdef HI_TECH_C		/* no huge pointers */
void far *_fnormalize(void far *poi);
#else
#define _fnormalize(poi) ((void huge *)(poi))
#endif
#endif

#endif
