#ifndef _GETOPT_L_H
#define _GETOPT_L_H

/* Symbolic constants for getopt_long */

#define no_argument 0		/* the option does not take an argument */
#define required_argument 1	/* the option requires an argument */
#define optional_argument 2	/* the option takes an optional argument */


/* Global variables for getopt_long */

#ifndef _GETOPT_L_C
extern char *optarg;
extern int optind, opterr, optopt;
#endif

/* Structure definition for getopt_long */

/*
  The meanings of the different fields are:

  name
   is the name of the long option.

  has_arg
   no_argument (or 0) if the option does not take an argument,
   required_argument (or 1) if the option requires an argument, or
   optional_argument (or 2) if the option takes an optional argument.

  flag
   specifies how results are returned for a long option.  If flag is
   NULL, then getopt_long() returns val.  (For example, the calling
   program may set val to the equivalent short option character.)
   Otherwise, getopt_long() returns 0, and flag points to a variable
   which is set to val if the option is found, but left unchanged if
   the option is not found.

  val
   is the value to return, or to load into the variable pointed to by
   flag.
*/

/* The last element of the array has to be filled with zeroes.  */

struct option {
  const char *name;
  int has_arg;
  int *flag;
  int val;
};


/* Function prototype for getopt_long */

int getopt_long(int argc, char *const argv[],
		const char *optstring,
		const struct option *longopts, int *longindex);

#endif /* _GETOPT_L_H */
