/*      DRAW.C - part of the FreeDAPI
        Copyright 1999 - Enrico Bartky

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <graphics.h>
#include <dapi.h>

void DrawButton(int x, int y, int x1, int y1, char *txt)
{
 setcolor(0);
 rectangle(x,y,x1,y1);
 rectangle(x+1,y+1,x1-1,y1-1);
 setfillstyle(1,7);
 bar(x+2,y+2,x1-2,y1-2);
 setcolor(15);
 line(x+2,y+2,x1-2,y+2);
 line(x+2,y+2,x+2,y1-2);
 setcolor(0);
 outtextxy(x+4,y+4,txt);
}

void DrawWindow(int x, int y, int x1, int y1,char *title)
{
 setfillstyle(1,15);
 bar(x,y,x1,y1);
 setcolor(1);
 rectangle(x,y,x1,y1);
 rectangle(x+1,y+1,x1-1,y1-1);
 rectangle(x+2,y+2,x1-2,y1-2);
 setfillstyle(1,1);
 bar(x+4,y+4,x1-4,y+TXTHIGH+10);
 setcolor(15);
 outtextxy(x+7,y+7,title);
}

void DrawCheck(HCHECK Check)
{
 setcolor(0);
 outtextxy(Check.x,Check.y,"[ ]");
 outtextxy(Check.x+25,Check.y,Check.txt);
}

void DrawRadio(HRADIO Radio)
{
 setcolor(0);
 outtextxy(Radio.x,Radio.y,"( )");
 outtextxy(Radio.x+25,Radio.y,Radio.txt);
}

