/* $Id: db.c,v 1.2 2000/05/26 20:23:27 jhall Exp $ */

/* A library of functions that implements a key-value database using a
   hash as the data storage/retrieval system. */

/*
  Copyright (C) 1999-2000 Jim Hall <jhall1@isd.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* Concept borrowed from _The C Programming Language_, Second Ed.,
   BWK/DMR. */

#include <stdio.h>
#include <stdlib.h>			/* malloc */
#include <string.h>			/* strdup */

#include "db.h"


/* Function prototypes */

unsigned hash (char *s);


/* Global variables */

static db_t *hashtab[HASHSIZE];


/* Functions */

/* hash() - My hash function.  This is a little simple, but it will
   suffice. */

unsigned
hash (char *s)
{
  unsigned hashval;

  for (hashval = 0; *s != '\0'; s++)
    {
      /* assign a hash value (iterative) */

      hashval = *s + 31 * hashval;
    }

  /* return the hash value */

  return (hashval % HASHSIZE);
}

/* db_fetch() - Query the hash and return a struct that contains the
   key and the pointer.  The calling function should not look beyond
   that. */

db_t *
db_fetch (char *s)
{
  db_t *db_ptr;

  for (db_ptr = hashtab[hash(s)]; db_ptr != NULL; db_ptr = db_ptr->next)
    {
      if (strcmp (s, db_ptr->key) == 0)
	{
	  /* found it */

	  return (db_ptr);
	}
    }

  /* else, not found */

  return (NULL);
}

/* db_insert() - Inserts a key,value pair into the hash.  If the key
   already exists in the hash, the new value is NOT inserted. */

db_t *
db_insert (char *key, char *value)
{
  db_t *db_ptr;
  unsigned hashval;

  if ((db_ptr = db_fetch (key)) == NULL)
    {
      /* not found */

      db_ptr = (db_t *) malloc (sizeof (*db_ptr));

      if (db_ptr == NULL || (db_ptr->key = strdup (key)) == NULL)
	{
	  return (NULL);
	}

      /* insert the key,value into the hash. */

      hashval = hash(key);
      db_ptr->next = hashtab[hashval];
      hashtab[hashval] = db_ptr;
    }

  else
    {
      /* already there */

      free ((void *) db_ptr->value);
    }

  if ((db_ptr ->value = strdup (value)) == NULL)
    {
      return (NULL);
    }

  /* else */

  return (db_ptr);
}

int
db_init (size_t init_size)
{
  /* This is deprecated.  So let's fake it. */

  return (1);
}

int
db_free (void)
{
  /* This is deprecated.  So let's fake it. */

  return (1);
}

int db_compare (db_t *p1, db_t *p2)
{
  /* This is deprecated.  No one should be accessing this function
     anyway. So let's fake it. */

  return (0);
}
