/* cats.c */

/* sample program */

/*
  Copyright (C) 1999-2000 Jim Hall <jhall1@isd.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include "catgets.h"

int
main (void)
{
  char *s;
  nl_catd catd;

  /* open the language catalog */

  printf ("** You will also need to set NLSPATH to the location of the catalog\n");
  printf ("** files, and LANG to the 2-letter country abbreviation that you use.\n");

  catd = catopen ("cats", 1);

  /* print strings from the catalog */

  printf ("Samples from using catgets:\n");

  s = catgets (catd, 1, 0, "Hello world");
  printf ("%s\n", s);

  s = catgets (catd, 1, 1, "this is a test");
  printf ("%s\n", s);

  /* close the language catalog */

  catclose (catd);

  /* done */

  exit (0);
}
