/*
 * Simplistic example program for the APEG add-on library
 */

#include <string.h>
#include <stdio.h>

#include <allegro.h>
#include "apeg.h"


int main(int argc, char *argv[])
{
	int ret, depth;

	if(allegro_init() != 0)
	{
		fprintf(stderr, "Error initializing Allegro: %s\n", allegro_error);
		return -1;
	}

	// Check to make sure we have enough cmd-line args
	if(argc < 2)
	{
		allegro_message("Usage: %s <filename.mpg>\n"
		                "  <filename.mpg> can be either a file or an embedded datafile object.\n",
		                argv[0]);

		return 1;
	}

	install_timer();

	install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);

	// Set gfx mode
	depth = desktop_color_depth();
	if(!depth)
		depth = 8;

	set_color_depth(depth);
	if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0)
	{
		if(set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0) != 0)
		{
			allegro_message("Couldn't set mode 640x480x%i:\n%s\n", depth,
							allegro_error);
			return -1;
		}
	}
	clear_to_color(screen, makecol(0, 0, 0));

	install_keyboard();

	ret = apeg_play_mpg(argv[1], screen, FALSE, NULL);
	if(ret == APEG_ERROR)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("APEG Error: %s\n", apeg_error);
	}

	return ret;
}
END_OF_MAIN()
