\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : ZILOG Z80 microprocessor 
\ CATEGORY    : Simulations 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -environ


        S" STACK-CELLS" ENVIRONMENT? [IF]
                #150 > [IF]


        NEEDS -z80lib


        ?DEF -z80 [IF] -z80 [THEN]

        MARKER -z80



hex

reset clearlabels

trgseg 2@ swap 0 fillp

z80asm  clr-a;  forth

8 == rst_8
                ei
                ret
asm;

10 == rst_10
                ei
                ret
asm;

18 == rst_18
                ei
                ret
asm;

20 == rst_20
                ei
                ret
asm;

28 == rst_28
                ei
                ret
asm;

30 == rst_30
                ei
                ret
asm;

200 org

label vlag      db 0
label teller    db 0    teller vlag - constant ^teller
label teller2   db 0    teller2 vlag - constant ^teller2
label teller3   db 0    teller3 vlag - constant ^teller3
label letter    db 0    letter vlag - constant ^letter
label schuif    db 0    schuif vlag - constant ^schuif
label woord     dw 101  woord vlag - constant ^woord

C000 == sp0

D000 == data

z80asm clr-a;

300 == ysub
                push    h
                push    d
                )inr    %y 0
                )ld     e       %y 0
                inc     %y xh
                push    %y xh
                pop     h
                ld      a       l
                cp#     4
        cs not  if
                ldp#    %y xh   data
        then
                )st     e       %y 0
                pop     d
                pop     h
                ret
asm;

38 == intsrv
                di
                push    af
                )ld     a       ^teller2
                )st     a       ^teller3
                )ld     a       ^teller
                )st     a       ^teller2
                )ld     a       ^letter
                )st     a       ^teller
                )rlc    ^woord
                )rrc    ^woord 1+
                call    ysub
                pop     af
                ei
                ret
asm;

66 == nmi
                rst     0
asm;

100 == main
                ldp#    sp      sp0
                ldp#    xh      vlag
                ldp#    %y xh   data
                )ld#    %y 0    bl
                )ld#    0       1
                )ld#    ^teller 0
                scf
                )ld#    ^letter 'A'
                )set    7       0
                )res    7       0
                ei
        begin
                )inr    ^letter
                )ld     a       ^letter
                cp#     'Z'
        cs not until
                halt
        begin
                )der    0
                )ld     a       1
                )st     a       2
        again
asm;

0 org
asm:
                di
                jp      main
asm;

400 == mul
                nop
                ret
asm;

label fac
                push    xh
                ldp#    xh      0
                addp    x       sp
                )ld     l       4
                )ld     h       5
                ld      a       e
                or      d
        0= not  if
                push    h
                call    fac
                pop     d
                call    mul
                pop     xh
                ret
        then
                ldp#    h       1
                pop     xh
                ret
asm;

label bitter
                bit     3       a
                bit     4       a
                bit     3       m
                )bit    3       0
                )bit    3       1
                )bit    4       0
                set     3       a
                res     3       a
                ret
asm;

: go
        page
        begin   10 10 choose + steps intsrv interrupt stop?
        until
        home ;

: fill-memory
        [ z80asm ]
        500 to here-t
        100 0
        do      fence @ i + c@ c,-t
        [ forth ] loop ;


        [ELSE]

cr
cr .(      The stacks must be more than 150 elements deep.)
cr .(      Now there are only ) s" STACK-CELLS" environment? drop .dec
   .( cells on the stack.)
cr .(      Recompile the kernel -- patching is too complicated.)
cr

        [THEN]

        [ELSE]

cr
cr .(      There are probably less than 150 cells available per stack.)
cr .(      But I can't find that out.)
cr .(      Recompile the kernel -- patching is too complicated.)
cr

        [THEN]


                            \ (* End of Source *) /
