\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : ?????????? 
\ CATEGORY    : Standard Programs 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : August 23, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -speaker

        NEEDS -dvalues
        

        ?DEF -sound [IF] -sound [THEN]


        MARKER -sound


        PRIVATES


DOC
(*
 Access the PC-speaker from iForth. Portable? Of course. Not.

 Necessary pointers are : 

    A counter of the number of notes
    A counter of TONE-ON  ticks
    A counter of TONE-OFF ticks
    A pointer to the next block of Frequency, TONE-ON-tick, TONE-OFF-tick

 The layout of the soundfile is:

 <#notes>  { frequency , tone-on , tone-off } * #notes ....


 INIT       init pointers   

 PLAY does the following : 

                    BEGIN ==========|
                                    |       
            |---------------- Toff  = 0? -------------------|
        No, TOFF state                                  Yes, TON state
            |                                               |
        DEC TONE-OFF ticks                              DEC TONE-ON ticks
            |                                               |
        IF <> 0  =================> AGAIN <============== IF <> 0
    ELSE ---|                                       ELSE ---|
            |                                               |
        DEC #NOTES                                          |
            |                                               |
        IF 0  STOP                                          |
            |                                               |
        Get next note, process,                             |
        Speaker on,                                     Speaker off,
    Set TONE-ON ticks ========> AGAIN <===========  Set TONE-OFF ticks.
*)
ENDDOC


#13 #10 DVALUE slowness -- adjust for your hardware and taste ... 13 10 == -30%

: WAIT-A-SEC        ( x -- )
        slowness */ MS
        ;  PRIVATE

: PLAY-BUFFER       ( addr -- )
        @+ 0
        ?DO     @+ SET-FREQUENCY
                @+ SPEAKER-ON    WAIT-A-SEC
                @+ SPEAKER-OFF   WAIT-A-SEC
                KEY?
                IF      LEAVE
                THEN
        LOOP 
        DROP KEY?
        IF      KEY DROP
        THEN
        ;

: ALLOCATE      ( x -- addr ior )
        HERE SWAP ALLOT FALSE
        ;

: FREE          ( addr -- ior )
        [ INTERNAL ] TO DP [ FORTH ] FALSE
        ;

' THROW ALIAS ?ALLOCATE     ( ior -- )

: FPLAY             ( c-addr u -- )
        R/O BIN OPEN-FILE THROW >R
        R@ FILE-SIZE THROW DROP 
        DUP ALLOCATE ?ALLOCATE
        DUP ROT R@ READ-FILE THROW DROP
        R> CLOSE-FILE THROW
        DUP PLAY-BUFFER
        FREE ?ALLOCATE
        ;

: PLAY              ( ccc -- )
        BL WORD 1+ C@ >UPC
        CASE
                'P' OF S" PYTHON.DAT"   ENDOF   \ Theme Monty Python
                'W' OF S" WACHTAUF.DAT" ENDOF   \ Wachtauf
                'C' OF S" CMINOR.DAT"   ENDOF   \ Cminor
                0. ROT
        ENDCASE
        DUP 0=
        IF      2DROP CR ." Don't know that one." EXIT
        THEN
        FPLAY
        ;

: .HELP
        CR ." *** Play sound files *** "
        CR ." PLAY p | w | c  for the Python theme, Wachtauf or Cminor" 
        CR ." Press ESC to abort. 
        CR ." (xx yy TO slowness slows it down xx/yy times, slowness now " 
        #100 slowness */ 0 .R ." %)"
        ;

.HELP

        DEPRIVE

                            \ (* End of Source *) /
