\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Send output to a printfile
\ CATEGORY    : Utilities
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : August 26, 1994, Coos Haak 
\ CREATED     : August 07, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        ?DEF -printer [IF] -printer [THEN]


        MARKER -printer


\G Create a new file with name ccc and send subsequent output of
\G EMIT and TYPE to it.
: PRINT:        ( ccc -- )                      \ PRINTER "print-colon"
        bl parse-word w/o create-file throw     \ open file
        to phandle                              \ signal CHForth
        printer                                 \ all output to printer now
        ;

\G Open an existing printfile with name ccc and and append
\G subsequent output of EMIT and TYPE at the end of it.
: PRINT+:       ( ccc -- )                      \ PRINTER "print-plus-colon"
        bl parse-word r/w open-file throw       \ open file
        to phandle                              \ signal CHForth
        phandle file-size throw                 \ get size of file
        phandle reposition-file throw           \ append to end of file
        printer                                 \ all output to printer now
        ;

\G Close the printfile opened by PRINT: or PRINT+: and send
\G subsequent output to the screen.
: PRINT;        ( -- )                          \ PRINTER "print-semicolon"
        video                                   \ all output to screen now
        phandle close-file throw                \ close printfile
        clear phandle                           \ signal to CHForth
        ;

DOC

print: printer.prn
.( Dit is een test voor het maken) cr
.( van afdrukbestanden) cr
.(      'printfiles') cr
print;

ENDDOC

                            \ (* End of Source *) /
