\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Delete all stack words, use locals now!
\ CATEGORY    : Destructive Forth
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : September 13, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        ?DEF -nostack [IF] -nostack [THEN]


        MARKER -nostack


internal also forth

: >lwc
        local char
        char 'A' [ 'Z' 1+ ] literal within
        if      char bl or
        else    char
        then
    ;

: (zapwords)
        0 local offset
        begin   another
        while   dup head>flags h@ =ansi and 0=
                if      4 cells + to offset
                        offset hseg over c@x bounds
                        do      hseg i 1+ c@x >lwc
                                hseg i 1+ c!x
                        loop
                else    drop
                then
        repeat
    ;

: zapwords
        every?
        if      voc-link
                begin   dup voc@ temporary ! (zapwords)
                        @ ?dup 0=
                until
        else    get-context voc@ temporary ! (zapwords)
        then
    ;

previous forth

                            \ (* End of Source *) /
