?DEF -dhry [IF] -dhry [THEN]

MARKER -dhry

: ALLOT     ( n -- )
        DUP HERE + LIMIT HERE WITHIN -8 ?ERROR
        ALLOT
    ;

\ Extensions: 
: <C! swap C! ;
: <!  swap ! ; 
\ : []CELL  swap cells + ; ( array access)
: CVAR VARIABLE ; ( byte variable)
: ALLOT0 ( n -- ) ALLOT ; ( allot and erase)
\ : RECURSIVE : immediate ( "unhides" current word)
\ : PACK ( c-addr1 u c-addr -- c-addr ) ;
: ?ALLOCATE ( ior -- ) drop ;
\ Use of LOCAL is not standard.

: ALLOCATE ( n -- addr ior ) HERE SWAP ALLOT FALSE ;
: FREE ( n -- ior ) [ INTERNAL ] TO DP [ FORTH ] FALSE ;
: NOP ;
: <= > INVERT ;
: >= < INVERT ;
-- -------------------------------------------------------------------

(*  PL/1; a famous benchmark  *) 

(* 
 *   "DHRYSTONE" Benchmark Program
 *
 *   Version:   PL/1/#1
 *   Date:      Sept 10 '94
 *   Author:    Reinhold P. Weicker,  CACM Vol 27, No 10, 10/84 pg. 1013
 *         C version translated from ADA by Rick Richardson
 *         Every method to preserve ADA-likeness has been used,
 *         at the expense of C-ness.
 *         Modula-2 version translated from C by Kevin Northover.
 *         Again every attempt made to avoid distortions of the original.
 *         PL/1 version by Marcel Hendrix.
 * Machine Specifics.
 *         The LOOPS constant is initially set for 50000 loops.
 *         If you have a machine with large integers and is
Id       very fast, please change this number to 500000 to
 *         get better accuracy.
 *
 **********************************************************************o**
*
 *
 *   The following program contains statements of a high-level 
programming
 *   language (PL/1) in a distribution considered representative:
 *
 *   assignments         53%
 *   control statements      32%
 *   procedure, function calls   15%
 *
 *   100 statements are dynamically executed.  The program is balanced 
with
 *   respect to the three aspects:
 *      - statement type
 *      - operand type (for simple data types)
 *      - operand access
Id       operand global, local, parameter, or constant.
 *
 *   The combination of these three aspects is balanced only 
approximately.
 *
 *   The program does not compute anything meaningfull, but it is
 *   syntactically and semantically correct.
 *
  *) 
(*  Accuracy of timings and human fatigue controlled by next two lines  
*) 

VARIABLE IntGlob 
CREATE BoolGlob 4 ALLOT0 
CVAR Char1Glob 
CVAR Char2Glob 
CREATE Array1Glob 204 ALLOT0 
CREATE Array2Glob 10404 ALLOT0 
VARIABLE PtrGlb 
VARIABLE PtrGlbNext 
VARIABLE P1 
VARIABLE P2 
VARIABLE String2 
VARIABLE String1 


: Proc7 RECURSIVE 
        LOCALS| IntParI2 IntParI1 | 
        0 LOCAL IntLoc 

        IntParI1 2 + TO IntLoc IntParI2 IntLoc + ; 

: Proc3 RECURSIVE 
        LOCALS| PtrParOut | PtrGlb NOP 
           IF PtrParOut PtrGlb @ @ <! 
         ELSE IntGlob 100 <! 
         THEN 
        PtrGlb @ 12 + 10 IntGlob @ Proc7 <! ; 

: Func3 RECURSIVE 
        LOCALS| EnumParIn | 
        0 LOCAL EnumLoc 

        EnumParIn TO EnumLoc EnumLoc 2 = ; 

: Proc6 RECURSIVE 
        LOCALS| EnumParIn | 
        0 LOCAL EnumParOut 

        EnumParIn TO EnumParOut EnumParIn Func3 INVERT 
           IF 3 TO EnumParOut 
         THEN 
        EnumParIn 
        CASE 
           0 OF 
           0 TO EnumParOut ENDOF 
           1 OF IntGlob @ 100 > 
              IF 0 TO EnumParOut 
            ELSE 3 TO EnumParOut 
            THEN 
           ENDOF 
           2 OF 
           1 TO EnumParOut ENDOF 
           3 OF ENDOF 
           4 OF 
           2 TO EnumParOut ENDOF 
           
        ENDCASE 
        EnumParOut ; 

: Proc1 RECURSIVE 
        LOCALS| PtrParIn | 
        PtrParIn @ @ PtrGlb @ SWAP 47 MOVE 
        PtrParIn @ 12 + 5 <! 
        PtrParIn @ @ 12 + PtrParIn @ 12 + @ <! 
        PtrParIn @ @ PtrParIn @ @ <! 
        PtrParIn @ @ Proc3 PtrParIn @ @ CELL+ @ 0= 
           IF PtrParIn @ @ 12 + 6 <! 
              PtrParIn @ 8 + PtrParIn @ 8 + @ Proc6 <! 
              PtrParIn @ @ PtrGlb @ @ <! 
              PtrParIn @ @ 12 + PtrParIn @ @ 12 + @ 10 Proc7 <! 
         ELSE PtrParIn @ PtrParIn @ @ SWAP 47 MOVE 
         THEN 
        ; 

: Proc2 RECURSIVE 
        LOCALS| IntParIO | 
        0 LOCAL IntLoc 

        0 LOCAL EnumLoc 

        IntParIO 10 + TO IntLoc 
        BEGIN Char1Glob C@ 65 = 
              IF -1 +TO IntLoc 
                 IntLoc IntGlob @ - TO IntParIO 
                 0 TO EnumLoc 
            THEN 
           EnumLoc 0= 
        UNTIL 
        IntParIO ; 

: Proc4 RECURSIVE 
        0 LOCAL BoolLoc 

        Char1Glob C@ 65 = TO BoolLoc 
        BoolLoc BoolGlob @ OR TO BoolLoc 
        Char2Glob 66 <C! ; 

: Proc5 RECURSIVE 
        Char1Glob 65 <C! 
        BoolGlob 0 <! ; 

: Proc8 RECURSIVE 
        LOCALS| IntParI2 IntParI1 | 
        LOCALS| Array2Par | 
        LOCALS| Array1Par | 
        0 LOCAL IntIndex 
        0 LOCAL IntLoc 

        IntParI1 5 + TO IntLoc 
        Array1Par @ IntLoc SWAP []CELL IntParI2 <! 
        Array1Par @ IntLoc 1 + SWAP []CELL 
           Array1Par @ IntLoc SWAP []CELL @ <! 
        Array1Par @ IntLoc 30 + SWAP []CELL IntLoc <! 
        IntLoc IntLoc 1 + 1+ SWAP 
              DO 
                  Array2Par @ IntLoc SWAP []CELL I 204 * + IntLoc <! 
            LOOP 
        Array2Par @ IntLoc SWAP []CELL IntLoc 1 - 204 * + 
        Array2Par @ IntLoc SWAP []CELL IntLoc 1 - 204 * + @ 1 + <! 
        Array2Par @ IntLoc 20 + SWAP []CELL IntLoc 204 * + 
        Array1Par @ IntLoc SWAP []CELL @ <! 
        IntGlob 5 <! ; 

: Func1 RECURSIVE 
        LOCALS| CharPar2 CharPar1 | 
        0 LOCAL CharLoc2 
        0 LOCAL CharLoc1 

        0 LOCAL Func1Result 

        CharPar1 TO CharLoc1 
        CharLoc1 TO CharLoc2 CharLoc2 CharPar2 <> 
           IF 0 TO Func1Result 
         ELSE 1 TO Func1Result 
         THEN 
        Func1Result ; 

: CompareStr RECURSIVE 
        LOCALS| StrParI2 StrParI1 | 
        StrParI1 C@+ StrParI2 C@+ COMPARE ; 

: Func2 RECURSIVE 
        LOCALS| StrParI2 StrParI1 | 
        0 LOCAL IntLoc 

        0 LOCAL CharLoc 

        0 LOCAL Func2Result 

        2 TO IntLoc 
        BEGIN  
           IntLoc 2 <= 
        WHILE  
           StrParI1 @ IntLoc + C@ StrParI2 @ IntLoc 1 + + C@ Func1 0= 
              IF 65 TO CharLoc 1 +TO IntLoc 
            THEN 
           
        REPEAT 
        CharLoc 87 >= CharLoc 90 <= AND 
           IF 7 TO IntLoc 
         THEN 
        CharLoc 88 = 
           IF -1 TO Func2Result 
         ELSE StrParI1 StrParI2 CompareStr 0> 
                 IF 7 +TO IntLoc 
                    -1 TO Func2Result 
               ELSE 0 TO Func2Result 
               THEN 
              
         THEN 
        Func2Result ; 

: Proc0 RECURSIVE 
        0 LOCAL IntLoc1 

        0 LOCAL IntLoc2 

        0 LOCAL IntLoc3 

        0 LOCAL CharLoc 

        0 LOCAL CharIndex 

        0 LOCAL EnumLoc 

        0 LOCAL LoopMax 
        0 LOCAL ix 

        50000 TO LoopMax 
        47 ALLOCATE ?ALLOCATE PtrGlbNext ! 
        47 ALLOCATE ?ALLOCATE PtrGlb ! 
        PtrGlb @ PtrGlbNext @ <! 
        PtrGlb @ CELL+ 0 <! 
        PtrGlb @ 8 + 2 <! 
        PtrGlb @ 12 + 40 <! 
        PtrGlb @ 16 + C" DHRYSTONE PROGRAM, SOME STRING" COUNT ROT PACK 
DROP 
        31 ALLOCATE ?ALLOCATE String1 ! 
        String1 @ C" DHRYSTONE PROGRAM, 1'ST STRING" COUNT ROT PACK DROP 
        31 ALLOCATE ?ALLOCATE String2 ! 
        String2 @ C" DHRYSTONE PROGRAM, 2'ND STRING" COUNT ROT PACK DROP 
        0 LoopMax 1+ SWAP 
              DO Proc5 Proc4 
                  2 TO IntLoc1 
                  3 TO IntLoc2 
                  1 TO EnumLoc 
                  BoolGlob String1 String2 Func2 INVERT <! 
                  BEGIN  
                     IntLoc1 IntLoc2 < 
                  WHILE  
                     5 IntLoc1 * IntLoc2 - TO IntLoc3 
                     IntLoc1 IntLoc2 Proc7 TO IntLoc3 1 +TO IntLoc1 
                  REPEAT 
                  P1 Array1Glob <! 
                  P2 Array2Glob <! 
                  P1 P2 IntLoc1 IntLoc3 Proc8 
                  PtrGlb Proc1 
                  65 TO CharIndex 
                  BEGIN  
                     CharIndex Char2Glob C@ <= 
                  WHILE  
                     EnumLoc CharIndex 67 Func1 = 
                        IF 0 Proc6 TO EnumLoc 
                      THEN 
                     1 +TO CharIndex 
                  REPEAT 
                  IntLoc2 IntLoc1 * TO IntLoc3 
                  IntLoc3 IntLoc1 / TO IntLoc2 
                  7 IntLoc3 IntLoc2 - * IntLoc1 - TO IntLoc2 
                  IntLoc1 Proc2 TO IntLoc1 
            LOOP 
        String2 @ FREE ?ALLOCATE 
        String1 @ FREE ?ALLOCATE 
        PtrGlb @ FREE ?ALLOCATE 
        PtrGlbNext @ FREE ?ALLOCATE ; 
(* 
 The Main Program is trivial.  
 Compiled with PL/1 vsn 1.0 it took 7.6 seconds to run on an 386DX 33MHz,
 that's 6600 Dhrystones/sec. (iForth in Forth has over 34000/sec.)
 With emulated CompareStr:
 2.3 seconds => 21600 Dhrystones/sec. on 50 MHz 486DX (BP 7.0 : 17000 
 Dhrystones/sec)
 *) 

: dhry
        timer-reset Proc0 cr .elapsed
        #50000. #1000 gettime timesave 2@ d- drop m*/
        cr d. ." Dhrystones/sec. "
    ;