\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Postfix control stucture
\ CATEGORY    : Evaluating new programming tools
\ AUTHOR      : Gordon Charlton
\ LAST CHANGE : September 08, 1994, Coos Haak, CALL instead of EXECUTE
\ LAST CHANGE : August 27, 1994, Coos Haak
\ LAST CHANGE : August 27, 1994, Marcel Hendrix
\ CREATED     : August 26, 1994, Gordon Charlton
\ ----------------------------------------------------------------------



        S" CHFORTH" ENVIRONMENT? [IF] DROP

        NEEDS -stack

        [THEN]


        ?DEF -control1 [IF] -control1 [THEN]


        MARKER -control1


DOC

(*
  About {: ;} {COND} {IFELSE} {WHILE}

  You can do these very easily with a control flow stack.
  Main disadvantages of Gordon's code: 
   - deliberately obscure :-)
   - can't use {: ;} parts that leave something on the data stack.
 
 Assume the availability of an extra S-stack: >S  S> -S  S T
 Assume :NONAME can execute while compiling.

*) - Marcel

ENDDOC

DOC

  I use the coroutine technique with the word CALL , see for
  example Vijgeblad 38 pag 16. This may be not as fast as EXECUTE
  but now I don't have to cope with compiling an :ORPHAN that
  occupies space in the code segment. This implementation is also
  41 cells (code+list+head) shorter than the one with orphans.

  The only difference in the versions for CHForth and iForth is
  the word LHERE . In iForth this is the same as HERE , the
  dictionary pointer. But in CHForth colondefinitions are
  compiled in a separate segment. LHERE is the pointer there.

- Coos

ENDDOC

: CALL      ( la -- )               \ Execute from an address in list segment
        >R                          \ instead of an xt in code segment
    ;  COMPILE-ONLY

S" IFORTH" ENVIRONMENT? [IF]

DROP

: LHERE     ( -- addr )
        S" HERE " EVALUATE          \ This works in iForth
    ;  IMMEDIATE

[THEN]


: {: ( C: -- sys1 sys2 )
        POSTPONE AHEAD                              \ Compile forward branch
        LHERE                                       \ Keep la
    ;  IMMEDIATE  COMPILE-ONLY

: ;} ( C: sys1 sys2 -- ) ( S: executing; -- la )
        POSTPONE EXIT                               \ End subdefinition
        >R                                          \ Keep la on returnstack
        POSTPONE THEN                               \ Resolve branch
        R> POSTPONE LITERAL                         \ Compile la as a literal
        POSTPONE >S                                 \ Put it on s-stack later
    ;  IMMEDIATE  COMPILE-ONLY

: {IFELSE}  ( S: la la la)  
        S> S> 2>R                                   \ Move top two la's
        S> CALL                                     \ Execute the first
        IF      R> R>                               \ Place third on top
        ELSE    2R>                                 \ Place second on top
        THEN
        DROP                                        \ Throw that one away
        CALL                                        \ Execute the right one
    ;  COMPILE-ONLY

: {WHILE} ( S: la la)  
        BEGIN   T CALL                              \ Execute conditional la
        WHILE   S CALL                              \ Execute unconditional la
        REPEAT
        -S -S                                       \ Discard la's
    ;  COMPILE-ONLY

: {COND} ( S: la -- )
        S>                              \ Last la
        $DEADBEEF >S                    \ Put marker on s-stack
        0 >S                            \ and false flag
        CALL                            \ Put all la's on the s-stack
        BEGIN   S> S> CALL 0=           \ Get right part and execute left part
        WHILE   DROP                    \ Drop right part
        REPEAT
        CALL                            \ The right part
        BEGIN   -S S> $DEADBEEF =       \ Discard s-stack pairs
        UNTIL
    ;  COMPILE-ONLY

\ USAGE;
: TESTIFELSE
        {: KEY BL = ;} 
              {: ." spacebar " ;}
              {: ." some other key " ;}  
        {IFELSE} ;

\ is equivalent to 
\ : TT1   KEY BL = IF ." spacebar" ELSE ." some other key " THEN ;

\ USAGE; 
: TESTWHILE    
        {: CR ." press spacebar.." KEY BL <> ;}
        {: ." I said 'spacebar'" ;}
     {WHILE} ;

\ is equivalent to 
\ : TT2 BEGIN  CR ." press spacebar.." KEY BL <> 
\       WHILE  ." I said 'spacebar'"  
\       REPEAT ;

\ {: {: test1 ( --f) ;}  {: action1 ;}
\    {: test2 ( --f) ;}  {: action2 ;} 
\    {: test3 ( --f) ;}  {: action3 ;} 
\    {: test4 ( --f) ;}  {: action4 ;} 
\    {: TRUE ;}    {: defaultaction ;}  ;}  
\
\ Like COND in LISP {COND} evaluates each test clause
\ until one is true and then performs the associated action. If the
\ default action is do-nothing then it is possible to omit
\ {: TRUE ;} {: defaultaction ;}
\ In this implementation the tests are executed in reverse order.

: TESTCOND
  {: {: TRUE ;}  {: ."  You earned a cookie" ;}  
     {: CR ." press D.." KEY 'D' <> ;} {: ." I said 'D'" ;}
     {: CR ." press C.." KEY 'C' <> ;} {: ." I said 'C'" ;}
     {: CR ." press B.." KEY 'B' <> ;} {: ." I said 'B'" ;}
     {: CR ." press A.." KEY 'A' <> ;} {: ." I said 'A'" ;}  ;} 
  {COND} ;

                            \ (* End of Source *) /
