\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Datafile for CHForth administration
\ CATEGORY    : Utility
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : July 19, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -virtual

        ?DEF -chfdata [IF] -chfdata [THEN]


        MARKER -chfdata


DOC
  File system of Glen B. Haydon
  Without blocks
  Forth Dimensions III-2, page 45
ENDDOC

s" CHForth.dat" vfile place

0 value current                             \ current record number
0 value update?                             \ is record changed?
0 value /record                             \ size of a record
0 value total                               \ records in file

create buffer                               \ record buffer
    here 1024 dup allot erase               \ may be large enough

: write-record      ( x -- )                \ write record number x
        buffer /record rot /record m*       \ c-addr u file-pos(d)
        vs!                                 \ write data
        clear update?                       \ alread written
        ;

: read-record       ( x -- )                \ read record number x
        update?                             \ buffer occupied by another?
        if  current write-record            \ write it first
        then
        to current
        buffer /record current /record m*   \ c-addr u file-pos(d)
        vs@ drop                            \ throw away true length
        ;

: string            ( x1 x2 "name" -- x3 )  \ define a string field
        create  over ,                      \ compile offset
                dup ,                       \ compile size
                +                           \ new offset
        does>   2@ buffer + swap            \ get string
                ( -- c-addr u )
        ;

: integer           ( x1 "name" -- x2 )     \ define a integer field, 1 cell
        create  aligned dup , cell+         \ compile aligned offset
        does>   @ buffer +                  \ get address
        ;

: double            ( x1 "name" -- x2 )     \ define a double field, 2 cells
        create  aligned dup , cell+ cell+   \ compile aligned offset
        does>   @ buffer +                  \ get address
        ;

: record            ( x "name" -- )         \ keep size
        create  ,
        does>   @ to /record
        ;

: define            ( -- 0 )                \ start a record definition
        0
        ;

: update
        true to update?
        ;

: write
        update total write-record 1 +to total
        ;

define
    30 string naam
    30 string straat
    30 string plaats
     8 string postcode
    10 string datum
    11 string telefoon
     4 string versie
    integer flags       \ b0=meta,b1=fixed,b2=graphics
record datafile

clear total

1 1 lshift constant .meta
1 2 lshift constant .fixed
1 3 lshift constant .graphics

.meta .fixed .graphics or or constant .all

: $!        ( c-addr1 u1 c-addr2 u2 -- )        \ store string 1 in field 2
        2dup blank                              \ clear field 2
        rot min                                 \ maximum u2 characters
        cmove                                   \ move data
        ;

: naam:     ( "ccc" -- )
        '"' parse-word naam $!
        ;

: straat:
        '"' parse-word straat $!
        ;

: postcode:
        '"' parse-word postcode $!
        ;

: plaats:
        '"' parse-word plaats $!
        ;

: telefoon:
        '"' parse-word telefoon $!
        ;

: datum:
        '"' parse-word datum $!
        ;

: versie:
        '"' parse-word versie $!
        ;

: .file
    total 0
    do      cr cr ." Record " i .
            i read-record cr
            cr naam type    telefoon type space datum type space
            versie type space flags ?
            cr straat type  postcode type plaats type
            cr key drop
    loop
    ;

vopen           \ open file if not already open
datafile        \ set value /record

\ Write some date to the file.
    naam: Datafile written in CHForth
  straat: Written by Coos Haak
postcode: 
  plaats: For Dutch Forth GG
telefoon: 
   datum: 19-07-1994
  versie: Alle
   .all flags !
write

    naam: Coos Haak
  straat: Catharijnesteeg 5
postcode: 3512 NZ
  plaats: Utrecht
telefoon: 030-328726
   datum: 
  versie: Alle
   .all flags !
write

    naam: Willem Ouwerkerk
  straat: Boulevard Heuvelink 126
postcode: 6828 KW
  plaats: Arnhem
telefoon: 085-431305
   datum: 
  versie: 120
  .meta .fixed .graphics or or flags !
write

    naam: Marcel Hendrix
  straat: Kerkstraat 61
postcode: 6006 KL
  plaats: Weert
telefoon: 04950-41529
   datum: 
  versie: 110d
  .meta .fixed .graphics or or flags !
write

    naam: Maurits Wijzenbeek
  straat: Nieuwendammerdijk 254
postcode: 1025 LX
  plaats: Amsterdam
telefoon: 020-6362343
   datum: 
  versie: 110c
  .meta .fixed .graphics or or flags !
write

    naam: Lennart Benschop
  straat: Sibeliuslaan 35A
postcode: 5654 CZ
  plaats: Eindhoven
telefoon: 040-550970
   datum: 
  versie: 110d
  .meta .fixed .graphics or or flags !
write

    naam: Albert van der Horst
  straat: Oranjestraat 8
postcode: 35?? ??
  plaats: Utrecht
telefoon: 030-31248?
   datum: 
  versie: 110d
  .meta .fixed .graphics or or flags !
write

    naam: Cors Kroft
  straat: 
postcode: 
  plaats: Langeraar
telefoon: 
   datum: 
  versie: 110c
    flags off
write

    naam: Cees Groen
  straat: Molenwerf 8
postcode: 2941 TD
  plaats: Lekkerkerk
telefoon: 01805-2862
   datum: 
  versie: 109c
    flags off
write

    naam: Albert Nijhof
  straat: Steynstraat 13
postcode: 
  plaats: Arnhem
telefoon: 085-437701
   datum: 
  versie: 
    flags off
write

    naam: Jaap Juursema
  straat: Het Gangwerk 52
postcode: 1622 HC
  plaats: Hoorn
telefoon: 02290-33126
   datum: 
  versie: 109c
    flags off
write

    naam: Lothar Schmidt
  straat: 
postcode: 
  plaats: Arnhem
telefoon: 
   datum: 08-07-1994
  versie: 120
    flags off
write

    naam: Piet Degeling
  straat: Globeplein 38
postcode: 1334 BV
  plaats: Almere
telefoon: 
   datum: 
  versie: 110c
    flags off
write

    naam: Sjoerd Bakker
  straat: Tyassenbelt 42
postcode: 8014 NW
  plaats: Zwolle
telefoon: 
   datum: 
  versie: 110c
    flags off
write

    naam: Hendrik-Jan van Meerveld
  straat: Kerkpad 1
postcode: 7771 CS
  plaats: Hardenberg
telefoon: 
   datum: 18-07-1994
  versie: 120
    flags off
write

    naam: Ivo de Wijs
  straat:
postcode:
  plaats: Den Helder
telefoon:
   datum:
  versie:
    flags off
write

\ Read the records back
.file

vclose          \ end the session



                            \ (* End of Source *) /
