\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Count words in ASCII files 
\ CATEGORY    : Turnkey programs 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



create woorden 0 0 2,
create regels  0 0 2,
create tekens  0 0 2,

variable infile

true constant mp1300ai \ change to true if you have this Seikosha printer
        immediate

: .lower
        tuck 0
        ?do     count dup 'A' [ 'Z' 1+ ] literal within
                if      bl or
                then
                emit
        loop
        drop #15 swap - spaces
        ;

: prepare
        pad pack c@
        if      pad count '.' scan nip 0=
                if      s" .*" pad append
                then
                pad 1+ c@ '.' =
                if      pad count s" *" temporary pack append
                        temporary count pad place
                then
                pad count + 1- c@ '.' =
                if      s" *" pad count temporary pack append
                        temporary count pad place
                then
        else    drop s" *.*" pad place
        then
        pad count
        ;

: proces
        begin   temporary char+ /line infile @ read-line
                throw swap temporary c!
        while   temporary count dup 2 + s>d tekens d+! 1. regels d+!
                pad expand set-source
                begin   bl parse-word nip
                while   1. woorden d+!
                repeat
        repeat
        ;

: .help
        cr ." Counting of words, lines en charachters in ASCII-files."
mp1300ai [if]
        cr ." Also 80 x 66 pages or 160 x 88 pages."
[then]
        cr cr ."      WC filespec"
        ;

mp1300ai [if]

: .regels
        mu/mod rot 0<> s>d d- 4 d.r
        ;

[then]

: main
        decimal $80 count set-source
        bl word count 0=
        if      .help bye
        then
        count dup '-' = swap '/' = or
        if      count '?' =
                if      .help bye
                then
        then
        drop >in off ms-dos-io
        bl parse-word prepare find-first-file throw
        begin   found-file r/o open-file throw infile !
                found-file 'name place
                tekens d0! woorden d0! regels d0!
                proces
                infile @ close-file throw
                found-file tuck .lower
                tekens  2@ 7 d.r ."  characters,"
                woorden 2@ 6 d.r ."  words,"
                regels  2@ 5 d.r ."  lines"
mp1300ai [if]
                ." , "
                regels 2@  #60 .regels ."  or "
                regels 2@ #176 .regels ."  pages"
[then]
                '.' emit cr
                find-next-file
        until
        ;

signon off

turnkey main wc
                            \ (* End of Source *) /
