\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : ?????????? 
\ CATEGORY    : Standard Programs 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : July 28, 1994, Coos Haak 
\ ----------------------------------------------------------------------



internal also forth

here  limit  #5000 - dp  !
lhere llimit #5000 - ldp !
        NEEDS -assembler
ldp !
dp !

previous forth

create ID1 ", ** Running Bevan's Benchmark on a 40 MHz 486DLC using CHForth 1.2.3"
create ID2 ", ** CHForth is a real-mode direct-threaded 16-bits Forth."

code (nfib)             \ called
                pop     dx                      \ return address
                pop     eax                     \ the number
                push    dx                      \ restore return address
                cmp     eax, # 2        dw 0    \ long
        < if
                pop     dx                      \ pop return address
                push    sz: # 1                 \ push long result
                jmp     dx                      \ return
        then
                push    eax                     \ push paramer
                dec     eax                     \ minus one
                push    eax                     \ push another
                call    last @ head>            \ recursive call
                pop     ebx
                pop     eax
                inc     ebx
                push    ebx
                dec     eax
                dec     eax
                push    eax
                call    last @ head>            \ recursive call
                pop     eax
                pop     ebx
                add     eax, ebx
                pop     dx                      \ return address
                push    eax                     \ push result
                jmp     dx                      \ return
end-code

code nfibc              ( d1 -- d2 )
int 3
                rol     ebx, # #16
                pop     bx
                push    ebx
                call    ' (nfib)
                pop     ebx
                push    bx
                rol     ebx, # #16
                next
end-code

: main
        ms-dos-io $80 count set-source bl parse-word number? dup 1 =
        if      drop s>d
        else    2 <>
                if      cr ." Use:  NFIB nn" exit
                then
        then
        cr id1 count type cr id2 count type cr
        timer-reset nfibc d. .elapsed
        ;

turnkey main nfib
                            \ (* End of Source *) /
