\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Various mathematical loops 
\ CATEGORY    : Benchmarks 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -double
        NEEDS -quad


        MARKER -loops


: do:
        cr >in @ bl word count type >in ! 10 htab ' execute
    ;

: .difference
        gettime timesave 2@ d- 2>r
        1000.000.000 2r@ d/ 8 d.r ."  Hz "
        2r> <# # # # '.' hold #s #> 7 over - spaces type
        ."  microseconds per iteration "
    ;

: <<
        s" timer-reset 1000 0 do 1001 1 do"
        evaluate
    ;  immediate

: >>
        s" loop loop .difference" evaluate
    ;  immediate

: looptest
        << >> ;

: -test
        << i dup - drop >> ;

: *test
        << i dup * drop >> ;

: m*test
        << i dup m* 2drop >> ;

: d*test
        << i 0 2dup d* 2drop >> ;

: dum*test
        << i 0 2dup dum* 4drop >> ;

: /test
        << 32767 i / drop >> ;

: fm/modtest
        << 32767 0 i fm/mod 2drop >> ;

: sm/remtest
        << 32767 0 i sm/rem 2drop >> ;

: d/test
        << 32767 0 i 0 d/ 2drop >> ;

: */test
        << 32767 1 i */ drop >> ;

: m*/test
        << 32767 0 1 i m*/ 2drop >> ;

: d*/test
        << 32767 0 1 0 i 0 d*/ 2drop >> ;

: sqrttest
        << i 0 sqrt drop >> ;

                   \  CHForth 5.2.5 1.5.8 1.6.8 1.8.4   1.8.5         1.2.3
                   \  8086   8086    v30   v30  386SX  386 SX 386 SX  DLC486
                   \  8 Mhz  8 Mhz  8 Mhz 8 Mhz 16 Mhz 16 Mhz 16 Mhz  40 MHz
do: looptest       \  81917  58823  90909 90909 385505        385505 2604166
do: -test          \  27305  22727  30303 26315  85111         85111  551571
do: *test          \  17245  18181  25641 25641  85111         85111  568828
do: m*test         \  ?????  ?????  26315 25641  79921  85111  70468  520020
do: m*/test        \   2849   2985   3875  3968  11702  29789  29127  152951
do: d*/test        \    474    493    587   591   2226  29789  24362  133832
do: fm/modtest     \  13106  14084  18181 20408  66197         59578  303398
do: sm/remtest     \                                                  319386
do: /test          \  16383  16666  22727 22727  70468         70468  395726
do: d/test         \    527    540    643   645   2470  33098  33098  163988
do: sqrttest       \   4427   4545   4926  5076  15100         15100   87504
do: */test         \  11702  11363  18181 18181  63015         36207  216684
do: d*test         \   8191   9174  14084 14084  52012  54162  59578  337040
do: dum*test       \   5201   5208  10204 10101  38325  59578  52012  319386

                            \ (* End of Source *) /
