\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Numbers of Fibonacci 
\ CATEGORY    : Benchmarks 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------




        NEEDS -assembler

        MARKER -fibonacc



DOC
  Forth Dimensions IX, 4 blz 5
ENDDOC


10 constant ntimes
24 constant num

: fib
        dup 2 >
        if      dup 1 - recurse swap 2 - recurse +
        else    drop 1
        then ;

: fibloc
        local val val 2 >
        if      val 1 - recurse val 2 - recurse +
        else    1
        then ;

code (fibasm)
                cmp     bx, # 2
        > if
                push    bx
                dec     bx
                call    last @ head>
                pop     ax
                push    bx
                mov     bx, ax
                sub     bx, # 2
                call    last @ head>
                pop     ax
                add     bx, ax
        else
                mov     bx, # 1
        then
                ret     end-code

code fibasm
                call    ' (fibasm)
                next    end-code

: fibtest
        cr ntimes u. ." iterations of the standard benchmark."
        timer-reset 0 ntimes 0
        do      drop num fib
        loop
        cr .elapsed ."  Fibonacci(" num 2 .r ." ) = " u. ;

: fibasmtest
        cr ntimes u. ." iterations in assembler."
        timer-reset 0 ntimes 0
        do      drop num fibasm
        loop
        cr .elapsed ."  Fibonacci(" num 2 .r ." ) = " u. ;

: fibloctest
        cr ntimes u. ." iterations with LOCAL VAL"
        timer-reset 0 ntimes 0
        do      drop num fibloc
        loop
        cr .elapsed ."  Fibonacci(" num 2 .r ." ) = " u. ;



: .help
        CR
        CR ." Benchmarks on a 40 MHz 486DLC:"
        CR
        CR ."      FIBTEST     4.505 sec. Does the program."
        CR ."      FIBLOCTEST  6.089 sec. Keeps the values local."
        CR ."      FIBASMTEST  0.659 sec. Does it in no time."
        CR
        ;

.help

                            \ (* End of Source *) /
