\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Benchmarks from Forth Dimensions March/April '92, G. Kelly
\ CATEGORY    : Benchmarks 
\ AUTHOR      : Marcel Hendrix 
\ LAST CHANGE : February 2, 1993, Marcel Hendrix 
\ ----------------------------------------------------------------------



        NEEDS -assembler

        MARKER -fd92



\ Empty loop    Empty = XX

: X             30000 0 DO   LOOP ;
: XX                5 0 DO X LOOP ;


\ Threading     Thread = YY - XX

CODE NC
                NEXT    END-CODE

: Y             30000 0 DO  NC NC NC  NC NC NC  LOOP ;
: YY                5 0 DO  Y  LOOP ;


\ Nesting1      Nest1 = ZZ - XX

: N:    ;
: Z             30000 0 DO  N: N: N:  N: N: N:  LOOP ;
: ZZ                5 0 DO  Z  LOOP ;


\ Nesting2      Nest2 = WW - XX

: W1       ;    
: W2    W1 ;  
: W3    W2 ; 
: W4    W3 ;
: W5    W4 ;  
: W6    W5 ; 

: W             30000 0 DO  W6  LOOP ;
: WW                5 0 DO  W   LOOP ;


\ Primitives    Prims = QQ - XX
\ Exercise: variable constant @ ! + DUP SWAP OVER DROP

   VARIABLE LOC
10 CONSTANT TEN

: NULL          TEN DUP  LOC SWAP  OVER !  @ +  DROP ;
: Q             30000 0 DO  NULL  LOOP ;
: QQ                5 0 DO  Q     LOOP ;


\ Standard Sieve =  10 0 do  do-prime  loop 

8190 CONSTANT size
     CREATE   flags     size ALLOT

: DO-PRIME      flags size 1 FILL
                0  size 0 DO flags I + 
                             C@ IF I DUP +  3 +  
                                   DUP  I +
                                    BEGIN  DUP size <
                                    WHILE  0 OVER flags + C! 
                                           OVER + 
                                    REPEAT
                                   2DROP 1+  
                             ENDIF  
                        LOOP  ( count) DROP ;

: RR            10 0 DO DO-PRIME LOOP ;

: SS            S" testfile.frt" INCLUDED ;

: DO-TEST       CR ." *** Benchmark from FD March/April 1992, Guy Kelly ***"
                CR ." Empty  : " TIMER-RESET XX .ELAPSED
                CR ." Thread : " TIMER-RESET YY .ELAPSED
                CR ." Nest1  : " TIMER-RESET ZZ .ELAPSED
                CR ." Nest2  : " TIMER-RESET WW .ELAPSED
                CR ." Prims  : " TIMER-RESET QQ .ELAPSED
                CR ." Sieve  : " TIMER-RESET RR .ELAPSED 
                CR ." Loads  : " TIMER-RESET SS .ELAPSED ;
        

: .help
        CR ." ***    Benchmark from FD March/April 1992,  Guy Kelly   ***" 
        CR ." ***    Result on a '386 @ 33 MHz / '486 @ 50 MHz        ***" 
        CR ." ***    CHForth on a 486DLC @ 40 MHz                     ***"
        CR
        CR ."     BENCH   iForth3   iForth4    F-PC     tForth   dspForth  CHForth"
        CR ." --------------------------------------------------------------------"
        CR ."     Empty  : 0.055     0.00      0.17     0.211     0.070     0.054"
        CR ."     Thread : 0.715     0.22      0.76     0.989     0.609     0.274"
        CR ."     Nest1  : 1.210     0.44      2.31     1.845     0.070     1.043"
        CR ."     Nest2  : 0.495     0.165     2.30     0.745     0.070     1.098"
        CR ."     Prims  : 0.495     0.165     1.49     0.833     0.339     0.769"
        CR ."     Sieve  : 0.660     0.165     2.03     0.930     0.684     1.153"
        CR ."     Loads  : 0.165     0.055     0.11     0.277       --      0.164"
        CR CR ."      DO-TEST does the test."
        ;


.help
                            \ (* End of Source *) /
