\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Mouse 
\ CATEGORY    : Peripherals 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -graphics
        NEEDS -peripher

        MARKER -mouse


?undef sqrt [if]

code sqrt
                pop     ax
                mov     cx, ax
                or      cx, bx
                jnz     0 $
                mov     bx, ax
                next
        0 $:    mov     di, # 1
                xor     dx, dx
                mov     cx, # 14
        1 $:    add     ax, ax
                adc     bx, bx
                adc     dx, dx
                add     ax, ax
                adc     bx, bx
                adc     dx, dx
                sub     dx, di
                jae     2 $
                add     dx, di
                dec     di
                jmp     3 $
        2 $:    inc     di
        3 $:    add     di, di
                inc     di
                loop    1 $
                add     ax, ax
                adc     bx, bx
                adc     dx, dx
                add     ax, ax
                adc     bx, bx
                adc     dx, dx
                jae     4 $
                sub     dx, di
                inc     di
                jmp     6 $
        4 $:    cmp     dx, di
                jae     5 $
                dec     di
                jmp     6 $
        5 $:    sub     dx, di
                inc     di
        6 $:    cmp     dh, # $80
                jz      7 $
                add     ax, ax
                adc     bx, bx
                adc     dx, dx
                sub     bx, # $8000
                sbb     dx, di
                jb      8 $
        7 $:    inc     di
        8 $:    mov     bx, di
                next    end-code

[then]

: laatzien
        color mouse locals| y x kleur |
        white gray 2 0
        do      x 10 - y x 10 + y line 10 ms
                x y 10 - x y 10 + line 10 ms
        loop
        kleur to color ;

code shift
                push    bx
                mov     ah, # 2
                int     $16
                and     ax, # 3
                mov     bx, ax
                next    end-code

'P' value soort

: wachten
        color mouse locals| y x kleur |
        white gray
        begin   mouse 2dup x y line 10 ms 2dup x y line 10 ms button 1 =
        while   2drop
        repeat
        kleur to color x y 2swap ;

: rh_wachten
        color mouse locals| y x kleur |
        white gray
        begin   mouse 2dup x y box 10 ms 2dup x y box 10 ms button 1 =
        while   2drop
        repeat
        kleur to color x y 2swap ;

: +-
        0<
        if      negate
        then ;

: vk_wachten
        0 0 0 color mouse locals| y x kleur zijde dy dx |
        white gray
        begin   mouse y - to dy x - to dx
                dx abs dy abs min to zijde
                x y x zijde dx +- + y zijde dy +- + box 10 ms
                x y x zijde dx +- + y zijde dy +- + box 10 ms
                button 1 <>
        until
        kleur to color x y x zijde dx +- + y zijde dy +- + ;

: open_blokje
        rh_wachten box ;

: massief_blokje
        rh_wachten fillbox ;

: puntje
        begin   mouse plot button 1 <>
        until ;

: lijntje
        wachten line ;

: cirkeltje
        vk_wachten locals| y2 x2 y1 x1 |
        x1 x2 + 2 / y1 y2 + 2 / x1 x2 - abs 2/ circle ;

: schijfje
        vk_wachten locals| y2 x2 y1 x1 |
        x1 x2 + 2 / y1 y2 + 2 / x1 x2 - abs 2/ disk ;

: ellips
        locals| yr xr yc xc |
        xr yr >
        if      yr dup negate
                ?do     xr dup m* xr i yr */ dup m* d- sqrt xc +
                        yc i +
                        xc 2* pluck -
                        over line
                loop
                exit
        then
        xr dup negate
        ?do     xc i +
                yr dup m* yr i xr */ dup m* d- sqrt yc +
                over
                yc 2* pluck - line
        loop ;

: ellipsje
        rh_wachten locals| y2 x2 y1 x1 |
        x1 x2 + 2 /
        y1 y2 + 2 /
        x1 x2 - abs 2/
        y1 y2 - abs 2/ ellips ;

DOC
: spuit
        begin   mouse 10 - 20 choose + swap 10 - 20 choose + swap plot
                button 1 <>
        until ;
ENDDOC

: spuit
        begin   20 0
                do      mouse 10 - 20 choose + swap 10 - 20 choose + swap plot
                loop
                20 ms button 1 <>
        until ;

: kwast
        begin   mouse 10 - swap 10 - swap over 20 + over 20 + fillbox
                button 1 <>
        until ;

0 value einde

: figuur
        soort
        case
                'P' of  puntje  endof
                'B' of  massief_blokje  endof
                'E' of  ellipsje        endof
                'L' of  lijntje endof
                'C' of  cirkeltje       endof
                'S' of  schijfje        endof
                'O' of  open_blokje     endof
                'V' of  spuit   endof
                'K' of  kwast   endof
                'F' of  oldplot mouse fillarea newplot  endof
                ^[ of   true to einde   endof
        endcase ;

: go
        clear einde text?
        if      graphics
        then
        page 0 0 8 8 fillbox 1 l/scr 1- at-xy soort emit
        begin   laatzien
                [ internal ] getkey [ forth ]
                if      ekey>char drop dup ^[ =
                        if      drop true to einde
                        else    >upc dup to soort 1 l/scr 1- at-xy emit
                        then
                then
                button dup 1 =
                if      drop figuur
                else    dup 2 =
                        if      drop color 1+ maxc and to color
                                0 0 8 8 fillbox
                                begin   button 0=
                                until
                        else    4 =
                                if      true to einde
                                then
                        then
                then
                einde
        until
        home ;

                            \ (* End of Source *) /
