\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Mixing Forth and Assembler
\ CATEGORY    : Utility
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : June 26, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        ?DEF -mixlevel [IF] -mixlevel [THEN]


        MARKER -mixlevel



ASSEMBLER DEFINITIONS

: HILEVEL
                $ODD
                MOV     AX, # AHERE 3 +
                JMP     [ ' QUIT >CALL ] LITERAL
                $EVEN
        A; LHERE A, ] PREVIOUS
        ;

CODE (LOWLEVEL)
                LODSW   ES:
                XCHG    SP, BP
                POP     SI
                XCHG    SP, BP
                JMP     AX
END-CODE

also decompiler

:noname
        nl ." LOWLEVEL " cell+ l@ h. -r -r ;
        ' (lowlevel) tab!

previous

FORTH DEFINITIONS ASSEMBLER
                
: LOWLEVEL
        POSTPONE (LOWLEVEL)
        HERE L,
        POSTPONE [
[ ALSO INTERNAL ] POSTPONE (EXIT) [ PREVIOUS ]      \ For VIEW only
        >ASM
        ;  IMMEDIATE  COMPILE-ONLY

FORTH

code check
                cmp     bx, # 9
        > if
        hilevel
            ." Getal groter dan negen "
        lowlevel
        then
                cmp     bx, # 5
        < if
        hilevel
            ." Getal kleiner dan vijf "
        lowlevel
        then
        hilevel
            .
        lowlevel
                next
end-code

code roteer
        hilevel
            rot
        lowlevel
                next
end-code

                            \ (* End of Source *) /
