\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Demonstration of strings 
\ CATEGORY    : Examples 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------

        NEEDS -strings


        ?DEF -strdemo [IF] -strdemo [THEN]


        MARKER -strdemo



privates

string temp1    private
string temp2    private
string temp3    private

: spiegelen
        dup 1 >
        if      to temp1 clear temp2
                0 length temp1 1-
                ?do     temp1 i /string drop 1 +to temp2
                -1 +loop
                temp2
        then
        ;

: ispalin
        to temp3 temp3 spiegelen temp3 compare 0=
        ;

deprive

privates

string temp1    private
string temp2    private

: slrotate
        dup
        if      to temp1
                temp1 1 /string to temp2 temp1 drop 1 +to temp2 temp2
        then
        ;

: srrotate
        dup
        if      to temp1
                temp1 + 1- 1 to temp2 temp1 1- +to temp2 temp2
        then
        ;

deprive

string courant
string courant2

s"  Dit is een test met een lichtkrant, geschreven in KFX-forth door een"
        to courant
s"  gek op 19-7-1988 om 00:37:52. Hij heeft niets beters te doen dus het"
        +to courant
s"  gaat maar door en hij zal nooit klaar zijn om zijn biertje lekker"
        +to courant
s"  rustig op te drinken.        "
        +to courant

s"  Twee dagen na de Tweede Kamerverkiezingen een jaar later heeft dat"
        to courant2
s"  figuur er een raampje omheen gezet, dat horizontaal blijkt te kunnen"
        +to courant2
s"  schuiven, inplaats van vertikaal.             "
        +to courant2

: ?pal
        cr 2dup type cr 2dup spiegelen type space ispalin
        if      ." JA"
        else    ." NEE"
        then
        ;

: test
        cr ." Zijn dit palindromen ?"
        s" keldertrap" ?pal
        s" parterretrap" ?pal
        ;

: krant
        hide-cursor save-screen ?at page
        begin   home courant slrotate 2dup to courant type
                0 #5 at-xy courant2 srrotate 2dup to courant2 type
                200 ms stop?
        until
        restore-screen show-cursor at-xy
        ;

string een

: go
        s" Hello, world" to een
        cr een type clear een
        ;

: go2
        s" Hello, world!" to een
        adr een length een dump
        een dump
        clear een
        ;

: .help
        cr
        cr ."      Type KRANT voor een leuk effect "
        cr ."      Of toets TEST in " cr
        ;

.help

                            \ (* End of Source *) /
