\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Roman versus Arabic numbers 
\ CATEGORY    : Examples 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        MARKER -roman



DOC
  n >ROMAN           Gives a Roman number as a string.
  c-addr u ROMAN>    Gives an Arabic number.
  n .ROM             Prints a Roman number left in a field 16 wide.
  n CENTURY          Prints 100 Roman numbers.
  TEST               Test the program.
  GO                 Do some calculation.
ENDDOC


privates

variable hulp                           private
variable extra                          private

: (get)
        here + c@
        ;  private

: get
        extra @ (get)
        ;  private

: get1+
        extra @ 1+ (get)
        ;  private

: roman>                ( c-addr u -- x )
        hulp off 1 extra ! here 20 blank here pack count upper
        begin   get 'Q' =
        while   extra incr 10000 hulp +!
        repeat

        get 'W' =
        if      extra incr 5000 hulp +!
        then
        get1+ 'Q' =
        if      2 extra +! 9000 hulp +!
        else    get1+ 'W' =
                if      2 extra +! 4000 hulp +!
                else
                        begin   get 'M' =
                        while   extra incr 1000 hulp +!
                        repeat
                then
        then

        get 'D' =
        if      extra incr 500 hulp +!
        then
        get1+ 'M' =
        if      2 extra +! 900 hulp +!
        else    get1+ 'D' =
                if      2 extra +! 400 hulp +!
                else
                        begin   get 'C' =
                        while   extra incr 100 hulp +!
                        repeat
                then
        then

        get 'L' =
        if      extra incr 50 hulp +!
        then
        get1+ 'C' =
        if      2 extra +! 90 hulp +!
        else    get1+ 'L' =
                if      2 extra +! 40 hulp +!
                else
                        begin   get 'X' =
                        while   extra incr 10 hulp +!
                        repeat
                then
        then

        get 'V' =
        if      extra incr 5 hulp +!
        then
        get1+ 'X' =
        if      2 extra +! 9 hulp +!
        else    get1+ 'V' =
                if      2 extra +! 4 hulp +!
                else
                        begin   get 'I' =
                        while   extra incr hulp incr
                        repeat
                then
        then
        hulp @
        ;

create streng                                   private
        streng 20 dup allot erase

: put
        streng count + c! 1 streng c+!
        ;  private

: >roman                ( x -- c-addr u )
        0 of    s" ****" exit   then
        dup 1 < abort" Number must be greater than zero"
        streng off

        10000 /mod 0
        ?do     'Q' put
        loop
        1000 /mod
        9 of    'M' put 'Q' put
        else    4 of    'M' put 'W' put
                else    dup 4 >
                        if      5 - 'W' put
                        then
                        0
                        ?do     'M' put
                        loop
                then
        then

        1000 /mod 0
        ?do     'M' put
        loop
        100 /mod
        9 of    'C' put 'M' put
        else    4 of    'C' put 'D' put
                else    dup 4 >
                        if      5 - 'D' put
                        then
                        0
                        ?do     'C' put
                        loop
                then
        then

        100 /mod 0
        ?do     'C' put
        loop
        10 /mod
        9 of    'X' put 'C' put
        else    4 of    'X' put 'L' put
                else    dup 4 >
                        if      5 - 'L' put
                        then
                        0
                        ?do     'X' put
                        loop
                then
        then

        9 of    'I' put 'X' put
        else    4 of    'I' put 'V' put
                else    dup 4 >
                        if      5 - 'V' put
                        then
                        0
                        ?do     'I' put
                        loop
                then
        then

        streng count
        ;

: .rom                  ( x -- )
        >roman tuck type 16 swap - spaces
        ;

: century               ( x -- )
        1- dup 0< abort" Only from the first century"
        100 * 1+ 100 bounds cr
        do      i .rom key? ?leave
        loop
        ;

: test                  ( -- )
        40 0
        do      cr i 100 * 88 + dup 5 .r space .rom 200 ms
                stop? ?leave
        loop
        ;

: go                    ( -- )
        cr ." Type a roman number, I will take care of the translation."
        begin   cr refill
        while   bl parse-word dup
                while   ." is " roman> dup . ." and back: " >roman type
        repeat
                2drop
        then
        ;

deprive

                            \ (* End of Source *) /
