\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Make a useful .COM file 
\ CATEGORY    : Examples 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -assembler


        MARKER -hcc137



DOC
  An old program.
  I found it in my sources, called CHF151 from January 1991.
  Use cursor.com in a batch file:
    @echo off
    cls
    cursor (60,0)
    echo Right Upper
    cursor (0,22)
    echo Near Left bottom
    cursor (30,10)
    echo Near the middle
    cursor (0,23)
ENDDOC


create filename         $40 allot

s" cursor.com" filename place

code cursor
                mov     si, # $81               \ command tail
                mov     cl, # #10               \ maximal ten chars
        begin   lodsb
                cmp     al, # '('               \ read until left parenthesis
        0= until                                \ (required)
                lodsb                           \ first digit of x-coordinate
                sub     al, # '0'
                mov     dl, al
                lodsb
                cmp     al, # ','               \ not a comma
        0<> if
                sub     al, # '0'               \ then a second digit
                xchg    al, dl
                mul     cl
                add     dl, al
                inc     si
        then
                lodsb                           \ first digit of y-coordinate
                sub     al, # '0'
                mov     dh, al
                lodsb
                cmp     al, # ')'               \ not a right parenthesis
        0<> if
                sub     al, # '0'               \ then a second digit
                xchg    al, dh
                mul     cl
                add     dh, al
                inc     si
        then
                mov     bh, # 0                 \ page zero
                mov     ah, # 2                 \ set cursor
                int     $10                     \ bios call
                ret                             \ a zero is on the stack
end-code


here ' cursor - constant lengte

: write         ( c-addr u -- )
        filename count w/o bin create-file throw local file
        ['] cursor lengte file write-file throw
        file close-file throw ;

' cursor lengte dump

cr .( Make file [Y,n]) key >upc dup emit 'N' <>
[if]    write   [then]


                            \ (* End of Source *) /
