\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : Meta compiler for CHForth version 1.1.0 
\ FILENAME    : STRUCT.FRT 
\ DESCRIPTION : Internal structures and program control 
\ AUTHOR      : Coos Haak, Utrecht 
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



INTERNAL:

TH> T.CHR
CODE (CHR)              ( -- char )
                CLD
END-CODE  COMPILE-ONLY

TH> T.TIC
CODE (TIC)              ( -- xt )
                CLD
END-CODE  COMPILE-ONLY

TH> T.LIT
CODE (LIT)              ( -- x )
                LODSW   ES:
                PUSH    BX
                MOV     BX, AX
END-CODE  COMPILE-ONLY

EXTRA:

\G Does nothing.
CODE NOOP               ( -- )                  \ EXTRA "no-op"
                NEXT
END-CODE

INTERNAL:

TH> T.UNTIL
CODE (UNTIL)            ( x -- )
                TEST    BX, BX
                POP     BX
        0= IF
END-CODE  COMPILE-ONLY

TH> T.REPEAT
CODE (REPEAT)           ( -- )
                MOV     SI, ES: 0 [SI]
LABEL !_rep
                NEXT
                JMP     __brk
        THEN
                INC     SI
                INC     SI
                NEXT
END-CODE  COMPILE-ONLY

CODE (AHEAD)            ( -- )
                CLD
END-CODE  COMPILE-ONLY

TH> T.AGAIN
CODE (AGAIN)            ( -- )
                MOV     SI, ES: 0 [SI]
LABEL !_agn
                NEXT
                JMP     __brk
END-CODE  COMPILE-ONLY

TH> T.WHILE
CODE (WHILE)            ( x -- )
                CLD
END-CODE  COMPILE-ONLY

TH> T.IF
CODE (IF)               ( x -- )
                TEST    BX, BX
                POP     BX
        0= IF
END-CODE  COMPILE-ONLY

TH> T.ELSE
CODE (ELSE)             ( -- )
                MOV     SI, ES: 0 [SI]
END-CODE  COMPILE-ONLY

TH> T.THEN
CODE (THEN)             ( -- )
                NEXT
        THEN
                INC     SI
                INC     SI
END-CODE  COMPILE-ONLY

TH> T.BEGIN
CODE (BEGIN)            ( -- )
                NEXT
END-CODE  COMPILE-ONLY

TH> T.OF
CODE (OF)               ( x1 x2 -- | x1 )
                POP     AX
                CMP     AX, BX
        0<> IF
                MOV     BX, AX
END-CODE  COMPILE-ONLY

TH> T.ENDOF
CODE (ENDOF)            ( -- )
                MOV     SI, ES: 0 [SI]
                NEXT
        THEN
                INC     SI
                INC     SI
END-CODE  COMPILE-ONLY

TH> T.ENDCASE
CODE (ENDCASE)          ( x -- )
                POP     BX
END-CODE  COMPILE-ONLY

TH> T.CASE
CODE (CASE)              ( -- )
                NEXT
END-CODE  COMPILE-ONLY

TH> T.?DO
CODE (?DO)              ( x1 x2 -- )
                POP     DX
                CMP     BX, DX
        0= IF
                MOV     SI, ES: 0 [SI]
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY

TH> T.DO
CODE (DO)               ( x1 x2 -- )
                POP     DX
        THEN
                ADD     DH, # 80
                SUB     BX, DX
                INC     SI
                INC     SI
                XCHG    SP, BP
                PUSH    SI
                PUSH    DX
                PUSH    BX
                XCHG    SP, BP
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY

TH> T.+LOOP
CODE (+LOOP)            ( x -- )
                ADD     0 [BP], BX
                POP     BX
        AHEAD
END-CODE  COMPILE-ONLY

TH> T.LOOP
CODE (LOOP)             ( -- )
                INC     0 [BP]
        THEN
        NOV IF
                MOV     SI, 4 [BP]
LABEL !_loo
                NEXT
                JMP     __brk
END-CODE  COMPILE-ONLY

FORTH:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Excecution: ( -- ) ( R: loop-sys )
\G Discard the loop-control parameters for the current nesting
\G level. An UNLOOP is required for each nesting level before the
\G definition may be EXITed. An ambiguous condition exists if the
\G loop-control parameters are not available.
CODE UNLOOP                                     \ FORTH
        THEN
                ADD     BP, # 6
                NEXT
END-CODE  COMPILE-ONLY  ANS

-- locals

INTERNAL:

ALIGN
HERE-L MCONSTANT LocRetL
                HERE ,-L
ORPHAN LocRet
                ADD     lsp # 1 CELLS
                XCHG    SP, BP
                POP     SI
                XCHG    SP, BP
                NEXT
END-CODE

TH> T.LOCAL
CODE PUSH-LOCAL         ( x -- )
                XCHG    SP, BP
$IF386
                PUSH    # LocRetL
$ELSE
                MOV     AX, # LocRetL
                PUSH    AX
$THEN
                XCHG    SP, BP
                XCHG    SP, lsp
                PUSH    BX
                XCHG    SP, lsp
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY

TH> T.LOC@
CODE (LOC)              ( "name" -- x )
                LODSW   ES:
                MOV     DI, lsp
                ADD     DI, AX
                PUSH    BX
                MOV     BX, SS: 0 [DI]
                NEXT
END-CODE  COMPILE-ONLY

TH> T.LOC!
CODE (TOLOC)            ( x1 "name" -- )
                LODSW   ES:
                MOV     DI, lsp
                ADD     DI, AX
                MOV     SS: 0 [DI], BX
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY

TH> T.LOC+!
CODE (+TOLOC)           ( x1 "name" -- )
                LODSW   ES:
                MOV     DI, lsp
                ADD     DI, AX
                ADD     SS: 0 [DI], BX
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY

TH> T.LOC0!
CODE (CLEARLOC)         ( "name" -- )
                LODSW   ES:
                MOV     DI, lsp
                ADD     DI, AX
                MOV     SS: 0 [DI], # 0
                NEXT
END-CODE  COMPILE-ONLY

-- values

TH> T.VAL@
CODE (VAL)              ( "name" -- x )
                LODSW   ES:
                MOV     DI, AX
                PUSH    BX
                MOV     BX, 0 [DI]
                NEXT
END-CODE  COMPILE-ONLY

TH> T.VAL!
CODE (TO)               ( x1 "name" -- )
                LODSW   ES:
                MOV     DI, AX
                MOV     0 [DI], BX
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY

TH> T.VAL+!
CODE (+TO)              ( x "name" -- )
                LODSW   ES:
                MOV     DI, AX
                ADD     0 [DI], BX
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY

TH> T.VAL0!
CODE (CLEAR)            ( "name" -- )
                LODSW   ES:
                MOV     DI, AX
                MOV     0 [DI], # 0
                NEXT
END-CODE  COMPILE-ONLY

CODE (GET)              ( "name" -- addr )
                NOP
END-CODE  COMPILE-ONLY

CODE (ADR)              ( "name" -- addr )
                LODSW   ES:
                PUSH    BX
                MOV     BX, AX
                NEXT
END-CODE  COMPILE-ONLY

TH> T.VAL>R
CODE (PUSH)             ( "name" -- )
                LODSW   ES:
                MOV     DI, AX
                XCHG    SP, BP
                PUSH    0 [DI]
                XCHG    SP, BP
                NEXT
END-CODE  COMPILE-ONLY

TH> T.VALR>
CODE (POP)              ( "name" -- )
                LODSW   ES:
                MOV     DI, AX
                XCHG    SP, BP
                POP     0 [DI]
                XCHG    SP, BP
                NEXT
END-CODE  COMPILE-ONLY

TH> T.VEC!
CODE (IS)               ( x1 "name" -- )
                LODSW   ES:
                MOV     DI, AX
                MOV     0 [DI], BX
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY

\ FLYER

CODE DIVE               ( -- )
                XCHG    SI, 0 [BP]
                NEXT
END-CODE  COMPILE-ONLY

CODE DPSWAP             ( -- )
                MOV     AX, T' DP
                XCHG    AX, flycode
                MOV     T' DP AX
                MOV     AX, T' LDP
                XCHG    AX, flylist
                MOV     T' LDP AX
                MOV     AX, T' HDP
                XCHG    AX, flyhead
                MOV     T' HDP AX
                NEXT
END-CODE  COMPILE-ONLY

FORTH:

                            \ (* End of Source *) /
