\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : Meta compiler for CHForth version 1.1.0 
\ FILENAME    : NUMBERS.FRT 
\ DESCRIPTION : Number input and output 
\ AUTHOR      : Coos Haak, Utrecht 
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



EXTRA:

\G Try to convert char to a digit n1 with number base +n. If the
\G conversion succeeds, return a true flag. Otherwise a false flag.
CODE DIGIT              ( char +n -- n1 true | char false )     \ EXTRA
                POP     AX
                MOV     DX, AX                          \ keep char
                SUB     AL, # '0'
                JS      1 $
                CMP     AL, # A
                JS      0 $
                SUB     AL, # 7
                CMP     AL, # A
                JS      1 $
        0 $:    CMP     AL, BL
                JAE     1 $
                PUSH    AX
                MOV     BX, # TRUE
                NEXT
        1 $:    PUSH    DX                              \ push char
                XOR     BX, BX
                NEXT
                $EVEN
END-CODE

FORTH:

\G ud2 is the unsigned result of converting the characters within
\G the string specified by c-addr1 u1 into digits, using the number
\G in BASE , and adding each into ud1 after multiplying ud1 by the
\G number in BASE . Conversion continues left-to-right until a
\G character that is not convertible, including any "+" or "-" is
\G encountered or the string is entirely converted. c-addr2 is the
\G location of the first unconverted character or the first
\G character past the end of the string if the string was entirely
\G converted. u2 is the number of unconverted characters in the
\G string. An ambiguous condition exists if ud2 overflows during the
\G conversion.
: >NUMBER       ( ud1 c-addr1 u1 -- ud2 c-addr2 u2 )    \ FORTH "to-number"
        BEGIN   >R DUP C@ FROM BASE DIGIT R@ AND    \ a digit and not empty
        WHILE   >R -ROT                             \ hide c-addr
                FROM BASE U>D D* R> M+              \ multiply and add digit
                ROT R> 1 /STRING                    \ skip one character
        REPEAT
        DROP R>                                     \ drop non converted char
        ;  ANS

EXTRA:

\G Convert a string to a number. If it fails, return a false flag.
\G Otherwise return a single number with a flag of 1 and a double
\G number with a flag of 2. The number is negative if prefixed by
\G '-'. CHForth allows decimal numbers to be prefixed by '#' ,
\G hexadecimal numbers by '$' and binary numbers by '%' . These may
\G be followed by '-' to signify negative numbers. Single characters
\G are converted to single precision number when prefixed by '&' or
\G when they are enclosed by '''. Uppercase letters can be converted
\G to the corresponding control characters when prefixed by '^'.
: (NUMBER?)     ( c-addr u -- 0 | n 1 | d 2 )   \ EXTRA "paren-number-question"
        (LIT) notport OFF CHARFLAG OFF DPL ON DUP 0=
        IF      2DROP FALSE EXIT
        THEN
        FROM BASE LOCAL OldBase FALSE LOCAL Signed
        CASE OVER C@
        '#' OF  #10 TO BASE 1 /STRING (LIT) notport ON  ENDOF
        '$' OF  $10 TO BASE 1 /STRING (LIT) notport ON  ENDOF
        '%' OF  %10 TO BASE 1 /STRING (LIT) notport ON  ENDOF
        ''' OF  OVER CHAR+ CHAR+ C@ ''' = OVER 3 = AND
                IF      DROP CHAR+ C@ 1
                        CHARFLAG ON (LIT) notport ON EXIT
                THEN
                2DROP FALSE EXIT        ENDOF
        '&' OF  DUP 2 =
                IF      DROP CHAR+ C@ 1
                        CHARFLAG ON (LIT) notport ON EXIT
                THEN
                2DROP FALSE EXIT        ENDOF
        '^' OF  OVER CHAR+ C@ 40 60 WITHIN OVER 2 = AND
                IF      DROP CHAR+ C@ 1F AND 1
                        CHARFLAG ON (LIT) notport ON EXIT
                THEN
                2DROP FALSE EXIT        ENDOF
        ENDCASE
        DUP
        IF      OVER C@ '-' =
                IF      TRUE TO Signed 1 /STRING
                THEN
        THEN
        DUP
        IF      0 0 2SWAP
                BEGIN   >NUMBER OVER C@ '.' = OVER AND
                WHILE   1 /STRING DUP TO DPL
                REPEAT
                NIP
                IF      2DROP FALSE
                ELSE    Signed
                        IF      DNEGATE
                        THEN
                        FROM DPL 1+
                        IF      2
                        ELSE    DROP 1
                        THEN
                THEN
        ELSE    2DROP FALSE
        THEN
        OldBase TO BASE
        ;

FORTH:

\G Skip leading space delimiters, Parse name delimited by a space.
\G Put the value of its first character on the stack.
\G See also: [CHAR]
: CHAR          ( "name" -- char )              \ FORTH "char"
        BL PARSE-WORD DROP C@
        ;  ANS

EXTRA:

\G Skip leading space delimiters, Parse name delimited by a space.
\G Put the value of the control character defined by its first
\G character on the stack. Exception -531 occurs when the character
\G is not in the range {'@'..'_'}.
\G See also: CHAR [CTRL]
: CTRL          ( "name" -- char )              \ EXTRA "control"
        CHAR DUP 60 40 WITHIN #-531 ?ERROR
        1F AND
        ;

FORTH:

\G Set the numeric conversion radix to ten (decimal).
CODE DECIMAL            ( -- )                  \ FORTH
                MOV     T' BASE # A
                NEXT
END-CODE  ANS

\G Set the contents of BASE to sixteen.
CODE HEX                ( -- )                  \ FORTH
                MOV     T' BASE # 10
                NEXT
END-CODE  ANS

\G c-addr is the address of a transient region that can be used to
\G hold data for intermediate processing.
CODE PAD                ( -- c-addr )           \ FORTH
                PUSH    BX
                MOV     BX, T' DP
                ADD     BX, # 40
                NEXT
END-CODE  ANS

EXTRA:

\G c-addr is the address of a transient region that is used to hold
\G data for intermediate processing. This region is used by some
\G system words.
CODE TEMPORARY          ( -- c-addr )           \ EXTRA
                PUSH    BX
                MOV     BX, T' DP
                ADD     BX, # 140
                NEXT
END-CODE

FORTH:

\G Initialize the pictured numeric output conversion process.
\G See also: # #> #S
CODE <#                 ( -- )                  \ FORTH "less-number-sign"
                MOV     AX, T' DP
                ADD     AX, # 40
                MOV     HLD AX
                NEXT
END-CODE  ANS

\G Drop xd. Make the pictured numeric output string available as a
\G character string. c-addr and u specify the resulting character
\G string. A Standard Program may replace characters within the
\G string.
\G See also: # #S <#
CODE #>                 ( xd -- c-addr u )      \ FORTH "number-sign-greater"
                INC     SP
                INC     SP
                MOV     BX, T' DP
                ADD     BX, # 40
                MOV     AX, HLD
                SUB     BX, AX
                PUSH    AX
                NEXT
END-CODE  ANS

\G Divide ud1 by the number in BASE giving the quotient ud2 and the
\G remainder n. (n is the least-significant digit of ud1). Convert n
\G to external form and add the resulting character to the beginning
\G of the pictured numeric output string. An ambiguous condition
\G exists if # executes outside of a <# #> delimited number
\G conversion.
\G See also: #> #S <#
CODE #                  ( ud1 -- ud2 )          \ FORTH "number-sign"
                XOR     DX, DX
                MOV     AX, BX
                DIV     T' BASE
                MOV     CX, AX
                POP     AX
                DIV     T' BASE
                PUSH    AX
                PUSH    CX
                MOV     BX, DX
                CMP     BL, # 9
        > IF
                ADD     BL, # 7
        THEN
                ADD     BL, # '0'
END-CODE  ANS                                   \ fall-thru

\G Add char to the beginning of the pictured numeric output string.
\G An ambiguous condition exists if HOLD executes outside of a <# #>
\G delimited number conversion.
CODE HOLD               ( char -- )             \ FORTH
                MOV     DI, HLD
                DEC     DI
                MOV     HLD DI
                MOV     0 [DI], BL
                POP     BX
                NEXT
END-CODE  ANS

\G Convert one digit of ud1 according to the rule for # . Continue
\G conversion until the quotient is zero. An ambiguous condition
\G exists if #S executes outside of a <# #> delimited number
\G conversion.
\G See also: # #> <#
: #S                    ( ud1 -- ud2 )          \ FORTH "number-sign-s"
        BEGIN   # 2DUP D0=
        UNTIL
        ;  ANS

\G If n is negative, add a minus sign to the beginning of the
\G pictured numeric output string. An ambiguous condition exists if
\G SIGN executes outside of a <# #> delimited number conversion.
: SIGN          ( n -- )                        \ FORTH
        0<
        IF      '-' HOLD
        THEN
        ;  ANS

EXTRA:

\G Convert d to a numeric output string with a leading minus sign if
\G d is negative.
: (D.)          ( d -- c-addr u )               \ EXTRA "paren-d-dot"
        TUCK DABS <# #S ROT SIGN #>
        ;

FORTH:

\G Display d in free field format.
: D.            ( d -- )                        \ FORTH "d-dot"
        (D.) TYPE SPACE
        ;  ANS

\G Display d right aligned in a field n characters wide. If the
\G number of characters required to display d is greater than n, all
\G digits are displayed with no leading spaces in a field as wide as
\G necessary.
: D.R           ( d n -- )                      \ FORTH "d-dot-r"
        >R (D.) R> OVER - SPACES TYPE
        ;  ANS

EXTRA:

\G Convert n to a numeric output string with a leading minus sign if
\G n is negative.
: (.)           ( n -- c-addr u )               \ EXTRA "paren-dot"
        DUP ABS U>D <# #S ROT SIGN #>
        ;

FORTH:

\G Display n in free field format.
: .             ( n -- )                        \ FORTH "dot"
        (.) TYPE SPACE
        ;  ANS

\G Display n1 right aligned in a field n2 characters wide. If the
\G number of characters required to display n2 is greater than n2,
\G all digits are displayed with no leading spaces in a field as
\G wide as necessary.
: .R            ( n1 n2 -- )                    \ FORTH "dot-r"
        >R (.) R> OVER - SPACES TYPE
        ;  ANS

EXTRA:

\G Display ud in free field format.
: UD.           ( ud -- )                       \ EXTRA "u-d-dot"
        <# #S #> TYPE SPACE
        ;

\G Display ud right aligned in a field n characters wide. If the
\G number of characters required to display ud is greater than n,
\G all digits are displayed with no leading spaces in a field as
\G wide as necessary.
: UD.R          ( ud n -- )                     \ EXTRA "u-d-dot-r"
        >R <# #S #> R> OVER - SPACES TYPE
        ;

FORTH:

\G Display u in free field format.
: U.            ( u -- )                        \ FORTH "u-dot"
        U>D <# #S #> TYPE SPACE
        ;  ANS

\G Display u right aligned in a field n characters wide. If the
\G number of characters required to display u is greater than n, all
\G digits are displayed with no leading spaces in a field as wide as
\G necessary.
: U.R           ( u n -- )                      \ FORTH "u-dot-r"
        >R U>D <# #S #> R> OVER - SPACES TYPE
        ;  ANS

EXTRA:

\G Display u as a two digit hexadecimal number with a trailing
\G space.
\G See also: H.
: B.            ( u -- )                        \ EXTRA "b-dot"
        PUSH BASE HEX
        U>D <# # # #> TYPE SPACE
        POP BASE
        ;

:ORPHAN (H.)
        PUSH BASE HEX
        U>D <# # # # # #>
        POP BASE
        ;

\G Display u as a four digit hexadecimal number with a trailing
\G space.
\G See also: .HEX B.
: H.            ( u -- )                        \ EXTRA "h-dot"
        (H.) TYPE SPACE
        ;

\G Display u as a four digit hexadecimal number with a leading '$'
\G character and a trailing space.
\G See also: .DEC H.
: .HEX          ( u -- )                        \ EXTRA "dot-hex"
        '$' EMIT H.
        ;

\G Display u as a four character string if it corresponds to a
\G segment in CHForth else as a four digit hexadecimal string.
: .SEG          ( u -- )                        \ EXTRA "dot-segment"
        CASE
        CSEG     OF     ." cseg"        ENDOF
        LSEG     OF     ." lseg"        ENDOF
        HSEG     OF     ." hseg"        ENDOF
        STKSEG @ OF     ." sseg"        ENDOF
        ESEG     OF     ." eseg"        ENDOF
        DUP (H.) TYPE
        ENDCASE
        ;  

\G Display the extended address x-addr as a four character segment
\G name or number as in .SEG , a colon and a four digit hexadecimal
\G number and a space.
: X.            ( x-addr -- )                   \ EXTRA "x-dot"
        SWAP .SEG ':' EMIT H.
        ;

#CPU @ #386 = [IF]

\G Display the signon message. It will contain the name of the
\G program, the version number and the name of the author.
: .SIGNON       ( -- )                          \ EXTRA "dot-signon"
        PUSH BASE DECIMAL
        CR ." CHForth-386 "
        VERSION U>D <# # '.' HOLD # '.' HOLD # #>
        TYPE SPACE 0 FINDMESSAGE DROP ERR$ COUNT TYPE CR
        POP BASE
        ;

[ELSE]

: .SIGNON
        PUSH BASE DECIMAL
        CR ." CHForth-86 "
        VERSION U>D <# # '.' HOLD # '.' HOLD # #>
        TYPE SPACE 0 FINDMESSAGE DROP ERR$ COUNT TYPE CR
        POP BASE
        ;

[THEN]

\G Display the result of division of u by 1024 with one digit after
\G the decimal point followed by a space, the string "Kb" and a
\G space.
: KB.                   ( u -- )               \ EXTRA "k-b-dot"
        PUSH BASE DECIMAL
        #10 UM* #1024 UM/MOD NIP U>D
        <# BL HOLD 'b' HOLD 'K' HOLD BL HOLD
        # '.' HOLD #S #>
        8 OVER - SPACES TYPE
        POP BASE
        ;

:ORPHAN (.FREE)         ( u1 u2 -- )
\        DUP .HEX ." = " DUP KB. ." Free: " - KB.
        DUP .HEX ." - " OVER .HEX ." Used: " DUP KB. ." Free: " - KB.
        ;

\G Display the value of the three dictionary pointers and the free
\G space in their respective segments.
: .FREE                 ( -- )                  \ EXTRA "dot-free"
        CR ." Code and data     : " LIMIT HERE (.FREE)
        CR ." Colon definitions : " LLIMIT LHERE (.FREE)
        CR ." Headers           : " HLIMIT HHERE (.FREE)
        ;

FORTH:

\G Display the value stored at a-addr.
: ?                     ( a-addr -- )           \ FORTH "question"
        @ .
        ;  ANS

                            \ (* End of Source *) /
