\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : Meta compiler for CHForth version 1.1.0 
\ FILENAME    : MEMORY.FRT 
\ DESCRIPTION : Memory access 
\ AUTHOR      : Coos Haak, Utrecht 
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



\G Fetch x, x is the value stored at a-addr.
CODE @                  ( a-addr -- x )                 \ FORTH "fetch"
                MOV     BX, 0 [BX]                      \ fetch
                NEXT
END-CODE  ANS

\G Fetch the character stored at c-addr.
CODE C@                 ( c-addr -- char )              \ FORTH "c-fetch"
$IF386
                MOVZX   BX, 0 [BX]                      \ fetch
$ELSE
                MOV     BL, 0 [BX]                      \ fetch
                XOR     BH, BH                          \ high byte zero
$THEN
                NEXT
END-CODE  ANS

\G Fetch the cell pair x1 x2 stored at a-addr. x2 is stored at
\G a-addr and x1 at the next consecutive cell. It is equivalent to
\G the sequence DUP CELL+ @ SWAP @ .
\G See also: 2!
CODE 2@                 ( a-addr -- x1 x2 )             \ FORTH "two-fetch"
                PUSH    2 [BX]                          \ push low word
                MOV     BX, 0 [BX]                      \ fetch high word
                NEXT
END-CODE  ANS

\G Store x at a-addr.
CODE !                  ( x a-addr -- )                 \ FORTH "store"
                POP     0 [BX]                          \ pop word
                POP     BX                              \ pop TOS
                NEXT
END-CODE  ANS

\G Store char at c-addr.
CODE C!                 ( char c-addr -- )              \ FORTH "c-store"
                POP     AX
                MOV     0 [BX], AL                      \ move char
                POP     BX                              \ pop TOS
                NEXT
END-CODE  ANS

\G Store the cell pair x1 x2 at a-addr with x2 at a-addr and x1 at
\G the next consecutive cell. It is equivalent to the sequence SWAP
\G OVER ! CELL+ ! .
\G See also: 2@
CODE 2!                 ( x1 x2 a-addr -- )             \ FORTH "two-store"
                POP     0 [BX]                          \ pop high word
                POP     2 [BX]                          \ pop low word
                POP     BX                              \ pop TOS
                NEXT
END-CODE  ANS

\G Add n|u to the single-cell number at a-addr.
CODE +!                 ( n|u a-addr -- )               \ FORTH "plus-store"
                POP     AX
                ADD     0 [BX], AX                      \ add word
                POP     BX                              \ pop TOS
                NEXT
END-CODE  ANS

EXTRA:

\G Add char to the character at c-addr.
CODE C+!                ( char c-addr -- )              \ EXTRA "c-plus-store"
                POP     AX
                ADD     0 [BX], AL                      \ add char
                POP     BX                              \ pop TOS
                NEXT
END-CODE

\G Add d|ud to the double-cell number at a-addr.
CODE D+!                ( d|ud a-addr -- )              \ EXTRA "d-plus-store"
                POP     DX                              \ pop high word
                POP     AX                              \ pop low word
                ADD     2 [BX], AX                      \ add low word
                ADC     0 [BX], DX                      \ add high word
                POP     BX                              \ pop TOS
                NEXT
END-CODE

\G Fetch x from a-addr1. Add 1 CELLS to a-addr1 giving a-addr2.
CODE @+                 ( a-addr1 -- a-addr2 x )        \ EXTRA "fetch-plus"
                MOV     AX, BX                          \ copy address
                INC     AX                              \ increment with two
                INC     AX
                PUSH    AX                              \ push address
                MOV     BX, 0 [BX]                      \ fetch
                NEXT
END-CODE

FORTH:

\G Return the character string specification for the counted string
\G stored at c-addr1. c-addr2 is the address of the first character
\G after c-addr1. u is the contents of the character at c-addr1,
\G which is the length in characters of the string at c-addr2.
CODE COUNT              ( c-addr1 -- c-addr2 char )     \ FORTH
END-CODE  ANS

EXTRA:

\G Fetch char from c-addr1 and add 1 CHARS to c-addr1 giving
\G c-addr2.
CODE C@+                ( c-addr1 -- c-addr2 char )     \ EXTRA "c-fetch-plus"
                MOV     AX, BX                          \ copy address
                INC     AX                              \ increment with one
                PUSH    AX                              \ push address
$IF386
                MOVZX   BX, 0 [BX]                      \ fetch
$ELSE
                MOV     BL, 0 [BX]                      \ fetch
                XOR     BH, BH                          \ high byte zero
$THEN
                NEXT
END-CODE

FORTH:

\G If u is greater than zero, copy u consecutive characters,
\G character-by-character and left-to-right, from c-addr1 to
\G c-addr2. If c-addr2 lies within the source region, memory
\G propagation occurs. (c-addr2 lies within the source region if
\G c-addr2 is not less than c-addr1 and c-addr2 is less than the
\G quantity c-addr1 u CHARS + ).
\G See also: CMOVE> MOVE
CODE CMOVE      ( c-addr1 c-addr2 u -- )                \ FORTH "c-move"
                MOV     CX, BX                          \ copy length
                MOV     BX, SI                          \ save IP
                MOV     DX, ES                          \ save LSEG
                MOV     AX, DS                          \ copy CSEG
                MOV     ES, AX
                POP     DI                              \ pop destiny
                POP     SI                              \ pop source
                TEST    CX, CX                          \ test length
        > IF
                REP     MOVSB                           \ move bytes
        THEN
                MOV     ES, DX                          \ restore LSEG
                MOV     SI, BX                          \ restore IP
                POP     BX                              \ pop TOS
                NEXT
END-CODE  ANS

\G If u is greater than zero, copy u consecutive characters,
\G character-by-character and right-to-left, from c-addr1 to
\G c-addr2. If c-addr1 lies within the destination region, memory
\G propagation occurs. (c-addr1 lies within the destination region
\G if c-addr1 is greater than or equal to c-addr2 and if c-addr2 is
\G less than the quantity c-addr1 u CHARS + ).
\G See also: CMOVE MOVE 
CODE CMOVE>     ( c-addr1 c-addr2 u -- )                \ FORTH "c-move-up"
                MOV     CX, BX                          \ copy length
                MOV     BX, SI                          \ save IP
                MOV     DX, ES                          \ save LSEG
                MOV     AX, DS                          \ copy CSEG
                MOV     ES, AX
                POP     DI                              \ pop destiny
                POP     SI                              \ pop source
                TEST    CX, CX                          \ test length
        > IF
                DEC     CX                              \ decr length
                ADD     SI, CX                          \ add to source
                ADD     DI, CX                          \ add to length
                INC     CX                              \ incr length
                STD                                     \ move down
                REP     MOVSB                           \ move bytes
                CLD                                     \ move up, default
        THEN
                MOV     ES, DX                          \ restore LSEG
                MOV     SI, BX                          \ restore IP
                POP     BX                              \ pop TOS
                NEXT
END-CODE  ANS

\G If u is greater than zero, copy the contents of u consecutive
\G address units at addr1 to the u consecutive address units at
\G addr2. After MOVE completes, the u consecutive address units at
\G addr2 contain exactly what the u consecutive address units at
\G addr1 contained before the move.
\G See also: CMOVE CMOVE>
: MOVE          ( c-addr1 c-addr2 u -- )                \ FORTH
        >R 2DUP U<                                      \ source less than dest
        IF      R> CMOVE> EXIT                          \ move downward
        THEN
        R> CMOVE                                        \ move upward
        ;  ANS

\G If u is greater than zero, store char in each of u consecutive
\G characters of memory beginning at c-addr.
CODE FILL               ( c-addr u char -- )            \ FORTH
                MOV     AL, BL                          \ copy char
                POP     CX                              \ pop length
        BEGIN                                   \ destiny for BLANK
        BEGIN                                   \ destiny for ERASE
                POP     DI                              \ pop destiny
                TEST    CX, CX                          \ test length
        > IF
                MOV     DX, ES                          \ save LSEG
                MOV     BX, CS                          \ copy CSEG
                MOV     ES, BX
                REP     STOSB                           \ store bytes
                MOV     ES, DX                          \ restore LSEG
        THEN
                POP     BX                              \ pop TOS
                NEXT
END-CODE  ANS

\G If u is greater than zero, clear all bits in each of u
\G consecutive address units of memory beginning at c-addr.
CODE ERASE              ( c-addr u -- )                 \ FORTH
                XOR     AL, AL                          \ char is zero
                MOV     CX, BX                          \ copy length
        AGAIN                                   \ jump to FILL
END-CODE  ANS

\G If u is greater than zero, store the character value for space in
\G u consecutive character positions beginning at c-addr.
CODE BLANK              ( c-addr u -- )                 \ FORTH
                MOV     AL, # 20                        \ char is BL
                MOV     CX, BX                          \ copy length
        AGAIN                                   \ jump to FILL
END-CODE  ANS

EXTRA:

\G Set all bits of the single-cell value at a-addr.
CODE ON                 ( a-addr -- )                   \ EXTRA
                MOV     0 [BX], # TRUE                  \ set all bits
                POP     BX                              \ pop TOS
                NEXT
END-CODE

\G Clear all bits of the single-cell value at a-addr.
CODE OFF                ( a-addr -- )                   \ EXTRA
                MOV     0 [BX], # FALSE                 \ clear all bits
                POP     BX                              \ pop TOS
                NEXT
END-CODE

\G Add 1 to the single-cell value at a-addr.
CODE INCR               ( a-addr -- )                   \ EXTRA "increment"
                INC     0 [BX]                          \ increment cell
                POP     BX                              \ pop TOS
                NEXT
END-CODE

\G Subtract 1 from the single-cell value at a-addr.
CODE DECR               ( a-addr -- )                   \ EXTRA "decrement"
                DEC     0 [BX]                          \ decrement cell
                POP     BX                              \ pop TOS
                NEXT
END-CODE

\G Clear all bits of the character at c-addr.
CODE C0!                ( c-addr -- )                   \ EXTRA "c-zero-store"
                MOV     0 [BX], # 0 BYTE                \ clear all bits
                POP     BX                              \ pop TOS
                NEXT
END-CODE

\G Clear all bits of the double-cell value at a-addr.
CODE D0!                ( a-addr -- )                   \ EXTRA "d-zero-store"
                MOV     0 [BX], # 0                     \ clear all bits
                MOV     2 [BX], # 0                     \ clear all bits
                POP     BX                              \ pop TOS
                NEXT
END-CODE

\G Fetch x, x is the value stored at extended address x-addr.
CODE @X                 ( x-addr -- x )                 \ EXTRA "fetch-x"
                POP     DS                              \ pop segment
        BEGIN                                   \ destiny for H@
                MOV     BX, 0 [BX]                      \ fetch
                MOV     AX, CS                          \ restore CSEG
                MOV     DS, AX
                NEXT
END-CODE

\G Fetch x, x is the value stored at list address l-addr.
CODE L@                 ( l-addr -- x )                 \ EXTRA "l-fetch"
                MOV     BX, ES: 0 [BX]                  \ fetch
                NEXT
END-CODE

\G Fetch x, x is the value stored at header address h-addr.
CODE H@                 ( h-addr -- x )                 \ EXTRA "h-fetch"
                MOV     DS, hdrseg                      \ set segment
        AGAIN                                   \ jump to @X
END-CODE

\G Fetch the character stored at extended address x-addr.
CODE C@X                ( x-addr -- char )              \ EXTRA "c-fetch-x"
                POP     DS
$IF386
                MOVZX   BX, 0 [BX]
$ELSE
                MOV     BL, 0 [BX]
                XOR     BH, BH
$THEN
                MOV     AX, CS
                MOV     DS, AX
                NEXT
END-CODE

\G Fetch the character stored at list address l-addr.
CODE LC@                ( l-addr -- char )              \ EXTRA "l-c-fetch"
$IF386
                MOVZX   BX, ES: 0 [BX]
$ELSE
                MOV     BL, ES: 0 [BX]
                XOR     BH, BH
$THEN
                NEXT
END-CODE

\G Fetch the cell pair x1 x2 stored at extended address x-addr. x2
\G is stored at x-addr and x1 at the next consecutive cell. It is
\G equivalent to the sequence 2DUP CELL+ @X -ROT @X .
\G See also: 2!X
CODE 2@X               ( x-addr -- x1 x2 )              \ EXTRA "two-fetch-x"
                POP     DS
                PUSH    2 [BX]
                MOV     BX, 0 [BX]
                MOV     AX, CS
                MOV     DS, AX
                NEXT
END-CODE

\G Store x at extended address x-addr.
CODE !X                 ( x x-addr -- )                 \ EXTRA "store-x"
                POP     DS
                POP     0 [BX]
                POP     BX
                MOV     AX, CS
                MOV     DS, AX
                NEXT
END-CODE

\G Store x at list address l-addr.
CODE L!                 ( x l-addr -- )                 \ EXTRA "l-fetch"
                POP     ES: 0 [BX]
                POP     BX
                NEXT
END-CODE

\G Store x at header address h-addr.
CODE H!                 ( x h-addr -- )                 \ EXTRA "h-store"
                MOV     DS, hdrseg
                JMP     PTR !X 1+ END-CODE

\G Store char at extended address x-addr.
CODE C!X                ( c x-addr -- )                 \ EXTRA "c-store-x"
                POP     DS
                POP     AX
                MOV     0 [BX], AL
                POP     BX
                MOV     AX, CS
                MOV     DS, AX
                NEXT
END-CODE

\G Store char at list address l-addr.
CODE LC!                ( c l-addr -- )                 \ EXTRA "l-c-store"
                POP     AX
                MOV     ES: 0 [BX], AL
                POP     BX
                NEXT
END-CODE

\G Store the cell pair x1 x2 at extended address x-addr with x2 at
\G x-addr and x1 at the next consecutive cell. It is equivalent to
\G the sequence ROT >R 2DUP R> -ROT !X CELL+ ! .
\G See also: 2@X
CODE 2!X                ( x1 x2 x-addr -- )             \ EXTRA "two-store-x"
                POP     DS
                POP     0 [BX]
                POP     2 [BX]
                POP     BX
                MOV     AX, CS
                MOV     DS, AX
                NEXT
END-CODE

\G Add n|u to the single-cell value at extended address x-addr.
CODE +!X                ( n|u x-addr -- )               \ EXTRA "plus-store-x"
                POP     DS
                POP     AX
                ADD     0 [BX], AX
                POP     BX
                MOV     AX, CS
                MOV     DS, AX
                NEXT
END-CODE

\G Add char to the character at extended address x-addr.
CODE C+!X               ( char x-addr -- )          \ EXTRA "c-plus-store-x"
                POP     DS
                POP     AX
                ADD     0 [BX], AL
                POP     BX
                MOV     AX, CS
                MOV     DS, AX
                NEXT
END-CODE

\G Add d|ud to the double-cell value at extended address x-addr.
CODE D+!X               ( d|ud x-addr -- )          \ EXTRA "d-plus-store-x"
                POP     DS
                POP     DX
                POP     AX
                ADD     2 [BX], AX
                ADC     0 [BX], DX
                POP     BX
                MOV     AX, CS
                MOV     DS, AX
                NEXT
END-CODE

\G Fetch char from extended address x-addr1 and add 1 CHARS to
\G x-addr1 giving x-addr2.
CODE COUNTX             ( x-addr1 -- x-addr2 char )     \ EXTRA "count-x"
                POP     DS
                PUSH    DS
                MOV     AX, BX
                INC     AX
                PUSH    AX
$IF386
                MOVZX   BX, 0 [BX]
$ELSE
                MOV     BL, 0 [BX]
                XOR     BH, BH
$THEN
                MOV     AX, CS
                MOV     DS, AX
                NEXT
END-CODE

\G If u is greater than zero, copy u consecutive characters,
\G character-by-character and left-to-right, from extended address
\G x-addr1 to extended address x-addr2. If x-addr2 lies within the
\G source region, memory propagation occurs. (x-addr2 lies within
\G the source region if x-addr2 is not less than x-addr1 and x-addr2
\G is less than the quantity x-addr1 u CHARS + ).
\G See also: CMOVE CMOVEX>
CODE CMOVEX     ( x-addr1 x-addr2 u -- )                \ EXTRA "c-move-x"
                XCHG    SP, BP
                PUSH    SI
                PUSH    ES
                PUSH    DS
                XCHG    SP, BP
                MOV     CX, BX
                POP     DI
                POP     ES
                POP     SI
                POP     DS
                TEST    CX, CX
        > IF
                REP     MOVSB
        THEN
                XCHG    SP, BP
                POP     DS
                POP     ES
                POP     SI
                XCHG    SP, BP
                POP     BX
                NEXT
END-CODE

\G If u is greater than zero, copy u consecutive characters,
\G character-by-character and right-to-left, from extended address
\G x-addr1 to extended address x-addr2. If x-addr2 lies within the
\G source region, memory propagation occurs. (x-addr2 lies within
\G the source region if x-addr2 is not less than x-addr1 and x-addr2
\G is less than the quantity x-addr1 u CHARS + ).
\G See also: CMOVE CMOVEX
CODE CMOVEX>    ( x-addr1 x-addr2 u -- )                \ EXTRA "c-move-x-up"
                XCHG    SP, BP
                PUSH    SI
                PUSH    ES
                PUSH    DS
                XCHG    SP, BP
                MOV     CX, BX
                POP     DI
                POP     ES
                POP     SI
                POP     DS
                TEST    CX, CX
        > IF
                DEC     CX
                ADD     SI, CX
                ADD     DI, CX
                INC     CX
                STD
                REP     MOVSB
                CLD
        THEN
                XCHG    SP, BP
                POP     DS
                POP     ES
                POP     SI
                XCHG    SP, BP
                POP     BX
                NEXT
END-CODE

\G If u is greater than zero, store char in each of u consecutive
\G characters of memory beginning at extended address x-addr.
CODE FILLX              ( x-addr1 u char -- )           \ EXTRA "fill-x"
                MOV     DX, ES
                MOV     AX, BX
                POP     CX
                POP     DI
                POP     ES
                TEST    CX, CX
        > IF
                REP     STOSB
        THEN
                MOV     ES, DX
                POP     BX
                NEXT
END-CODE

\G x is the value of the combined code and data segment.
CODE CSEG               ( -- x )                        \ EXTRA
                PUSH    BX
                MOV     BX, CS
                NEXT
END-CODE

\G x is the value of the list segment.
CODE LSEG               ( -- x )                        \ EXTRA
                PUSH    BX
                MOV     BX, ES
                NEXT
END-CODE

\G x is the value of the header segment.
CODE HSEG               ( -- x )                        \ EXTRA
                PUSH    BX
                MOV     BX, hdrseg
                NEXT
END-CODE

\G x is the value of the DOS environment segment.
CODE ESEG               ( -- x )                        \ EXTRA
                PUSH    BX
                MOV     BX, envseg
                NEXT
END-CODE

\G n is the number of paragraphs in the environment segment.
CODE ELEN               ( -- n )                        \ EXTRA
                PUSH    BX
                MOV     BX, envmax
                NEXT
END-CODE

\G n2 is the minimum number of paragraphs needed to store n1
\G characters.
CODE #PARAGRAPHS        ( n1 -- n2 )            \ EXTRA "number-paragraphs"
                ADD     BX, # F
$IF386
                RCR     BX, # 4
$ELSE
                MOV     CL, # 4
                RCR     BX, CL
$THEN
                AND     BX, # 1FFF
                NEXT
END-CODE

\G n2 is the size in address units of n1 paragraphs.
CODE PARAGRAPHS         ( n1 -- n2 )                    \ EXTRA
$IF386
                SHL     BX, # 4
$ELSE
                MOV     CL, # 4
                SHL     BX, CL
$THEN
                NEXT
END-CODE

FORTH:

\G a-addr is the first aligned address greater than or equal to
\G addr.
CODE ALIGNED            ( addr -- a-addr )              \ FORTH
                INC     BX
                AND     BX, # FFFE
                NEXT
END-CODE  ANS

EXTRA:

\G a-addr is the first paragraph-aligned address greater than or
\G equal to addr.
CODE PARAGRAPH-ALIGNED  ( addr -- a-addr )              \ EXTRA
                ADD     BX, # F
                AND     BX, # FFF0
                NEXT
END-CODE

FORTH:

\G n2 is the size in address units of n1 characters.
CODE CHARS             ( n1 -- n2 )                     \ FORTH "chars"
END-CODE  ANS                                       \ empty, alias for #CHARS

EXTRA:

\G n2 is the minimum number of address units needed to store n1
\G characters. 
CODE #CHARS             ( n1 -- n2 )                    \ EXTRA "number-chars"
                NEXT                                    \ do nothing
END-CODE

FORTH:

\G Add the size in address units of a character to c-addr1 giving
\G c-addr2.
CODE CHAR+              ( c-addr1 -- c-addr2 )          \ FORTH "char-plus"
                INC     BX
                NEXT
END-CODE  ANS

EXTRA:

\G Subtract the size in address units of a character from c-addr1
\G giving c-addr2.
CODE CHAR-              ( c-addr1 -- c-addr2 )          \ EXTRA "char-minus"
                DEC     BX
                NEXT
END-CODE

\G Multiply x by the size in address units of a character and add it
\G to c-addr1 giving c-addr2.
CODE []CHAR     ( x c-addr1 -- c-addr2 )                \ EXTRA "char-array"
                POP     AX
                ADD     BX, AX
                NEXT
END-CODE

FORTH:

\G Add the size in address units of a cell to a-addr1 giving
\G a-addr2.
CODE CELL+              ( a-addr1 -- a-addr2 )          \ FORTH "cell-plus"
                ADD     BX, # 1 CELLS
                NEXT
END-CODE  ANS

EXTRA:

\G Subtract the size in address units of a cell from a-addr1 giving
\G a-addr2.
CODE CELL-              ( a-addr1 -- a-addr2 )          \ EXTRA "cell-minus"
                SUB     BX, # 1 CELLS
                NEXT
END-CODE

FORTH:

\G n2 is the size in address units of n1 cells.
CODE CELLS              ( n1 -- n2 )                    \ FORTH
                SHL     BX, # 1
                NEXT
END-CODE  ANS

EXTRA:

\G n2 is the minimum number of cells needed to store n1 characters.
CODE #CELLS             ( n1 -- n2 )                    \ EXTRA "number-cells"
                INC     BX
                SHR     BX, # 1
                NEXT
END-CODE

\G Multiply x by the size in address units of a cell and add it to
\G a-addr1 giving a-addr2.
CODE []CELL             ( x a-addr1 -- a-addr2 )        \ EXTRA "cell-array"
                POP     AX
                SHL     AX, # 1
                ADD     BX, AX
                NEXT
END-CODE

\G Multiply x by the size in address units of a double-cell and add
\G it to a-addr1 giving a-addr2.
CODE []DOUBLE           ( x a-addr1 -- a-addr2 )        \ EXTRA "double-array"
                POP     AX
$IF386
                SHL     AX, # 2
$ELSE
                SHL     AX, # 1
                SHL     AX, # 1
$THEN
                ADD     BX, AX
                NEXT
END-CODE

\G Read the 16 bit port x1.
CODE P@                 ( x1 -- x2 )                    \ EXTRA "p-fetch"
                MOV     DX, BX
                IN      AX, DX
                MOV     BX, AX
                NEXT
END-CODE

\G Read the 8 bit port x.
CODE PC@                ( x -- char )                   \ EXTRA "p-c-fetch"
                MOV     DX, BX
                IN      AL, DX
$IF386
                MOVZX   BX, AL
$ELSE
                XOR     AH, AH
                MOV     BX, AX
$THEN
                NEXT
END-CODE

\G Write x1 to 16 bit port x2.
CODE P!                 ( x1 x2 -- )                    \ EXTRA "p-store"
                MOV     DX, BX
                POP     AX
                OUT     DX, AX
                POP     BX
                NEXT
END-CODE

\G Write char to 8 bit port x.
CODE PC!                ( char x -- )                   \ EXTRA "p-c-store"
                MOV     DX, BX
                POP     AX
                OUT     DX, AL
                POP     BX
                NEXT
END-CODE

\G Reserve x address units above HERE to be used by ALLOT in a
\G saved program. Some space is always available in PAD and
\G TEMPORARY so interpreting remains possible if x is zero.
: RESERVE       ( x -- )                                \ EXTRA
        HERE 240 + + DUP -500 HERE 240 + WITHIN -8 ?ERROR
        DUP TO LIMIT 500 + TO MEMTOP
        ;

\G Reserve x address units above LHERE in the list segment to be
\G used by the compiler in a saved program. When x is zero, no
\G compiling is possible in the new program.
: LRESERVE      ( x -- )                                \ EXTRA
        LHERE + DUP -500 LHERE WITHIN -8 ?ERROR
        DUP TO LLIMIT 500 + TO LMEMTOP
        ;

\G Reserve x address units above HHERE in the head segment to be
\G used by the compiler in a saved program. When x is zero, all
\G headers of the definitions are discarded in the saved program.
: HRESERVE      ( x -- )                                \ EXTRA
        HHERE + DUP -500 HHERE WITHIN -8 ?ERROR
        DUP TO HLIMIT 500 + TO HMEMTOP
        ;

FORTH:

\G u is the amount of space remaining in the region addressed by
\G HERE , in address units.
: UNUSED        ( -- u )                                \ FORTH
        LIMIT HERE -
        ;  ANS

                            \ (* End of Source *) /
