\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : Meta compiler for CHForth version 1.1.0 
\ FILENAME    : MATH.FRT 
\ DESCRIPTION : Mathematical routines 
\ AUTHOR      : Coos Haak, Utrecht 
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



\G Add n2|u2 to n1|u1, giving the sum n3|u3.
CODE +                  ( n1|u1 n2|u2 -- n3|u3 )    \ FORTH "plus"
                POP     AX
                ADD     BX, AX
                NEXT
END-CODE  ANS

\G Add n to d1|ud1, giving the sum d1|ud2.
CODE M+                 ( d1|ud1 n -- d2|ud2 )      \ FORTH "m-plus"
                MOV     AX, BX
                CWD
                POP     BX
                POP     CX
                ADD     AX, CX
                ADC     BX, DX
                PUSH    AX
                NEXT
END-CODE  ANS

\G Add d2|ud2 to d1|ud1, giving the sum d3|ud3.
CODE D+                 ( d1|ud1 d2|ud2 -- d3|ud3 ) \ FORTH "d-plus"
                POP     AX
                POP     DX
                POP     CX
                ADD     AX, CX
                ADC     BX, DX
                PUSH    AX
                NEXT
END-CODE  ANS

\G Subtract n2|u2 from n1|u1, giving the difference n3|u3.
CODE -                  ( n1|u1 n2|u2 -- n3|u3 )    \ FORTH "minus"
                POP     AX
                SUB     AX, BX
                MOV     BX, AX
                NEXT
END-CODE  ANS

\G Subtract d2|ud2 from d1|ud1, giving the difference d3|ud3.
CODE D-                 ( d1|ud1 d2|ud2 -- d3|ud3 ) \ FORTH "d-minus"
                POP     AX
                POP     DX
                POP     CX
                SUB     CX, AX
                SBB     DX, BX
                PUSH    CX
                MOV     BX, DX
                NEXT
END-CODE  ANS

\G Add 1 to n1|u1 giving the sum n2|u2.
CODE 1+                 ( n1|u1 -- n2|u2 )          \ FORTH "one-plus"
                INC     BX
                NEXT
END-CODE  ANS

\G Subtract 1 from n1|u1 giving the difference n2|u2.
CODE 1-                 ( n1|u1 -- n2|u2 )          \ FORTH "one-minus"
                DEC     BX
                NEXT
END-CODE  ANS

\G u is the absolute value of n.
CODE ABS                ( n -- u )                  \ FORTH "abs"
                TEST    BX, BX
        0< IF
END-CODE  ANS

\G Negate n1, giving its aritmetic inverse n2.
\G See also: 0= INVERT
CODE NEGATE             ( n1 -- n2 )                \ FORTH
                NEG     BX
        THEN
                NEXT
END-CODE  ANS

\G ud is the absolute value of d.
CODE DABS               ( d -- ud )                 \ FORTH "d-abs"
                TEST    BX, BX
        0< IF
END-CODE  ANS

\G d1 is the negation of d1.
CODE DNEGATE            ( d1 -- d2 )                \ FORTH "d-negate"
                POP     AX
                NEG     BX
                NEG     AX
                SBB     BX, # 0
                PUSH    AX
        THEN
                NEXT
END-CODE  ANS

\G Convert the number n to the double-cell number d with the same
\G numerical value.
CODE S>D                ( n -- d )                  \ FORTH "s-to-d"
                PUSH    BX
                ADD     BX, BX
                SBB     BX, BX
                NEXT
END-CODE  ANS

\G n is the equivalent of d. An overflow occurs if d lies outside
\G the range of a signed single-cell number.
CODE D>S                ( d -- n )                  \ FORTH "d-to-s"
                POP     BX
                NEXT
END-CODE  ANS

EXTRA:

\G ud is the equivalent of u.
CODE U>D                ( u -- ud )                 \ EXTRA "u-to-d"
                PUSH    BX
                XOR     BX, BX
                NEXT
END-CODE

FORTH:

\G Multiply u1 by u2 giving the unsigned double-cell product ud. All
\G values and arithmetic are unsigned.
CODE UM*                ( u1 u2 -- ud )             \ FORTH "u-m-star"
                POP     AX
                MUL     BX
                PUSH    AX
                MOV     BX, DX
                NEXT
END-CODE  ANS

\G d is the signed product of n1 times n2.
CODE M*                 ( n1 n2 -- d )              \ FORTH "m-star"
                POP     AX
                IMUL    BX
                PUSH    AX
                MOV     BX, DX
                NEXT
END-CODE  ANS

\G Multiply n1|u1 by n2|u2 giving product n3|u3.
CODE *                  ( n1|u1 n2|u2 -- n3|u3 )    \ FORTH "star"
                POP     AX
                MUL     BX
                MOV     BX, AX
                NEXT
END-CODE  ANS

EXTRA:

\G Multiply d1|ud1 by d2|ud2 giving product d3|ud3.
CODE D*                 ( d1|ud1 d2|ud2 -- d3|ud3 ) \ EXTRA "d-star"
$IF386
                ROL     EBX, # 10
                POP     BX
                POP     EAX
                ROL     EAX, # 10
                MUL     EBX
                PUSH    AX
                ROL     EAX, # 10
                MOV     BX, AX
$ELSE
                POP     CX
                XCHG    SP, BP
                MOV     AX, 2 [BP]
                MUL     CX
                XCHG    2 [BP], AX
                MOV     DI, DX
                MUL     BX
                ADD     AX, DI
                XCHG    0 [BP], AX
                MUL     CX
                ADD     AX, 0 [BP]
                MOV     BX, AX
                XCHG    SP, BP
                POP     AX
$THEN
                NEXT
END-CODE

FORTH:

\G x2 is the result by shifting x1 one bit toward the
\G most-significant bit, filling the vacated least-significant bit
\G with zero.
CODE 2*                 ( x1 -- x2 )                \ FORTH "two-star"
                SHL     BX, # 1
                NEXT
END-CODE  ANS

\G xd2 is the result by shifting xd1 one bit toward the
\G most-significant bit, filling the vacated least-significant bit
\G with zero.
CODE D2*                ( xd1 -- xd2 )              \ FORTH "d-two-star"
                POP     AX
                SHL     AX, # 1
                RCL     BX, # 1
                PUSH    AX
                NEXT
END-CODE  ANS

\G Divide ud by u1, giving the quotient u3 and the remainder u2. All
\G values and arithmetic are unsigned. Exception -10 is issued if u1
\G is zero or if the quotient lies outside the range of a
\G single-cell unsigned integer.
\G See also: FM/MOD SM/REM
CODE UM/MOD             ( ud u1 -- u2 u3 )          \ FORTH "u-m-slash-mod"
                POP     DX
                POP     AX
                DIV     BX
                PUSH    DX
                MOV     BX, AX
                NEXT
END-CODE  ANS

EXTRA:

\G Divide ud1 by u1, giving the quotient ud2 and the remainder u2.
\G All values and arithmetic are unsigned.
\G **** Anders implementeren!
\G Exception -10 is issued if u1 is zero or if the quotient lies
\G outside the range of a double-cell unsigned integer.
: MU/MOD                ( ud1 u1 -- u2 ud2 )        \ EXTRA "m-u-slash-mod"
        >R U>D R@ UM/MOD R> SWAP >R UM/MOD R>
        ;

FORTH:

\G Divide d by n1, giving the floored quotient n3 and the remainder
\G n3. Input and output stack arguments are signed. Exception -10 is
\G issued if n1 is zero or the quotient lies outside the range of a
\G double-cell unsigned integer.
\G See also: SM/REM UM/MOD
CODE FM/MOD             ( d n1 -- n2 n3 )           \ FORTH "f-m-slash-mod"
                POP     DX
                POP     AX
                MOV     CX, BX
                XOR     CX, DX
        0>= IF
                IDIV    BX
                PUSH    DX
                MOV     BX, AX
                NEXT
        THEN
                IDIV    BX
                OR      DX, DX
        0<> IF
                ADD     DX, BX
                DEC     AX
        THEN
                PUSH    DX
                MOV     BX, AX
                NEXT
END-CODE  ANS

\G Divide d by n1, giving the symmetric quotient n3 and the
\G remainder n3. Input and output stack arguments are signed.
\G Exception -10 is issued if n1 is zero or the quotient lies
\G outside the range of a double-cell unsigned integer.
\G See also: FM/MOD UM/MOD
CODE SM/REM             ( d n1 -- n2 n3 )           \ FORTH "s-m-slash-rem"
                POP     DX
                POP     AX
                IDIV    BX
                PUSH    DX
                MOV     BX, AX
                NEXT
END-CODE  ANS

\G Divide n1 by n2, giving the single-cell remainder n3 and the
\G single-cell quotient n4. Exception -10 is issued if n1 is zero.
\G If n1 and n2 differ in sign the result returned will be the same
\G as returned by the phrase  >R S>D R> SM/REM . Note that other
\G implementations of the ANSI standard may return the result of the
\G phrase >R S>D R> FM/MOD .
CODE /MOD               ( x1 x2 -- x3 x4 )      \ FORTH "slash-mod"
                POP     AX
                CWD
                IDIV    BX
                PUSH    DX
                MOV     BX, AX
                NEXT
END-CODE  ANS

\G Divide n1 by n2, giving the single-cell quotient n3. Exception
\G -10 is issued if n1 is zero. If n1 and n2 differ in sign the
\G result returned will be the same as returned by the phrase >R S>D
\G R> SM/REM SWAP DROP . Note that other implementations of the ANSI
\G standard may return the result of the phrase >R S>D R> FM/MOD
\G SWAP DROP .
CODE /                  ( n1 n2 -- n3 )             \ FORTH "slash"
                POP     AX
                CWD
                IDIV    BX
                MOV     BX, AX
                NEXT
END-CODE  ANS

\G Divide n1 by n2, giving the single-cell remainder n3. Exception
\G -10 is issued if n1 is zero. If n1 and n2 differ in sign the
\G result returned will be the same as returned by the phrase >R S>D
\G R> SM/REM DROP . Note that other implementations of the ANSI
\G standard may return the result of the phrase >R S>D R> FM/MOD
\G DROP .
: MOD                   ( n1 n2 -- n3 )             \ FORTH "mod"
        /MOD DROP
        ;  ANS

\G Multiply n1 by n2 producing the double-cell intermediate result
\G d. Divide d by n3, giving the single-cell remainder n4 and the
\G single-cell quotient n5. Exception -10 is issued if n3 is zero or
\G if the quotient n5 lies outside the range of a single-cell signed
\G integer. If d and n3 differ in sign the result returned will be
\G the same as returned by the phrase >R M* R> SM/REM . Note that
\G other implementations of the ANSI standard may return the result
\G of the phrase >R M* R> FM/MOD .
CODE */MOD              ( n1 n2 n3 -- n4 n5 )       \ FORTH "star-slash-mod"
                POP     AX
                POP     CX
                IMUL    CX
                IDIV    BX
                PUSH    DX
                MOV     BX, AX
                NEXT
END-CODE  ANS

\G Multiply n1 by n2 producing the double-cell intermediate result
\G d. Divide d by n3, giving the single-cell quotient n4. Exception
\G -10 is issued if n3 is zero or if the quotient n4 lies outside
\G the range of a single-cell signed integer. If d and n3 differ in
\G sign the result returned will be the same as returned by the
\G phrase >R M* R> SM/REM SWAP DROP . Note that other
\G implementations of the ANSI standard may return the result of the
\G phrase >R M* R> FM/MOD SWAP DROP .
: */                    ( n1 n2 n3 -- n4 )          \ FORTH "star-slash"
        */MOD NIP
        ;  ANS

EXTRA:

\G Divide n1 by n2, giving the single-cell quotient n3. Exception
\G -10 is issued if n1 is zero. If n1 and n2 differ in sign the
\G result returned will be the same as returned by the phrase >R S>D
\G R> FM/MOD DROP .
CODE CIRCULAR           ( n1 n2 -- n3 )             \ EXTRA
                POP     AX
                CWD
                MOV     CX, BX
                XOR     CX, DX
        0>= IF
                IDIV    BX
        ELSE
                IDIV    BX
                TEST    DX, DX
        0<> IF
                ADD     DX, BX
        THEN
        THEN
                MOV     BX, DX
                NEXT
END-CODE

#CPU @ #386 = [IF]

\G Multiply d1 by n1 producing the triple-cell intermediate result
\G t. Divide t by +n2, giving the single-cell remainder n3 and the
\G double-cell quotient n4. Exception -10 is issued if +n2 is zero
\G or the quotient lies outside the range of a double-cell signed
\G integer.
\G
\G Note: The restriction in the Standard to postive values for +n2
\G is not maintained.
\G See also: */ */MOD M*/
CODE M*/MOD             ( d1 n1 +n2 -- n3 d2 )      \ EXTRA "m-star-slash-mod"
                MOVSX   EBX, BX
                POP     CX
                MOVSX   ECX, CX
                POP     EAX
                ROL     EAX, # 10
                IMUL    ECX
                IDIV    EBX
                PUSH    DX
                PUSH    AX
                ROL     EAX, # 10
                MOV     BX, AX
                NEXT
END-CODE

[ELSE]

ORPHAN TS/
                POP     DX
                POP     AX
                DIV     BX
                MOV     CX, AX
                POP     AX
                DIV     BX
                PUSH    DX
                PUSH    AX
                MOV     BX, CX
                NEXT
END-CODE

ORPHAN DS*
                POP     DI
                POP     AX
                MUL     BX
                PUSH    AX
                MOV     CX, DX
                MOV     AX, DI
                MUL     BX
                ADD     AX, CX
                ADC     DX, # 0
                PUSH    AX
                MOV     BX, DX
                NEXT
END-CODE

: M*/MOD
        OVER 3 PICK XOR >R >R >R DABS R> ABS DS* R@ ABS TS/
        R> R@ XOR 0<
        IF      DNEGATE
        THEN
        ROT R> 0<
        IF      NEGATE
        THEN
        -ROT
        ;

[THEN]

FORTH:

\G Multiply d1 by n1 producing the triple-cell intermediate result
\G t. Divide t by +n2, giving the double-cell quotient n3. Exception
\G -10 is issued if +n2 is zero or if the quotient lies outside the
\G range of a double-cell signed integer.
\G
\G Note: The restriction in the Standard to postive values for +n2
\G is not maintained.
\G See also: */ */MOD M*/MOD
: M*/               ( d1 n1 +n2 -- d2 )             \ FORTH "m-star-slash"
        M*/MOD ROT DROP
        ;  ANS

\G x2 is the result of shifting x1 one bit toward the
\G least-significant bit, leaving the most-significant bit
\G unchanged.
CODE 2/                 ( x1 -- x2 )                \ FORTH "two-slash"
                SAR     BX, # 1
                NEXT
END-CODE  ANS

EXTRA:

\G x2 is the result by shifting x1 one bit toward the
\G least-significant bit, filling the vacated most-significant bit
\G with zero.
CODE U2/                ( x1 -- x2 )                \ EXTRA "u-two-slash"
                SHR     BX, # 1
                NEXT
END-CODE

FORTH:

\G xd2 is the result of shifting xd1 one bit toward the
\G least-significant bit, leaving the most-significant bit
\G unchanged.
CODE D2/                ( xd1 -- xd2 )              \ FORTH "d-two-slash"
                POP     AX
                SAR     BX, # 1
                RCR     AX, # 1
                PUSH    AX
                NEXT
END-CODE  ANS

                            \ (* End of Source *) /
