\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : Meta compiler for CHForth version 1.1.0 
\ FILENAME    : HEADERS.FRT 
\ DESCRIPTION : Compiling headers 
\ AUTHOR      : Coos Haak, Utrecht 
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



EXTRA:

\G Create a dictionary entry named in the character string specified
\G by c-addr u, u may be zero. The name is not known to the Forth
\G system until REVEAL is executed. When WARNING does not contain
\G zero, give a warning when the name is not unique.
VECTOR HEAD,            ( c-addr u -- )         \ EXTRA "head-comma"

INTERNAL:

: (HEAD,)               ( c-addr u -- )
        HERE LIMIT 500 + U> -8 ?ERROR
        LHERE LLIMIT 500 + U> #-519 ?ERROR
        HHERE HLIMIT 500 + U> #-520 ?ERROR
        HERE PACK CASESENSITIVE @ INVERT
        IF      DUP COUNT UPPER
        THEN
        COUNT + C0! WARNING @ IN-METHODS 0= AND
        IF      HERE FIND NIP
                IF      #-513 .MESS
                THEN
        THEN
        GET-CURRENT VOC@ H@ CNHASH HERE CNHASH <>
        IF      HHERE HERE CNHASH DUP H@ ROT UMIN SWAP H!
        THEN
        GET-CURRENT HHERE LAST 2!                       -- wid dea
        GET-CURRENT VOC@ H,                             -- link
        ANSI @
        IF      =ANSI
        ELSE    0
        THEN    H,                                      -- head>flags
        0 H,                                            -- head>forget
        HERE H,                                         -- head>
        HERE DUP C@ 1F MIN 1+ #CELLS 0                  -- >head
        DO      @+ H,
        LOOP
        DROP HHERE HERE CNHASH CELL+ H! TRUE TO HEAD?
        ;

SETVECTOR HEAD, (HEAD,)

EXTRA:

\G If POSTFIX is zero, skip leading space delimiters and parse name
\G delimited by a space; otherwise name is specified by the
\G character string c-addr u. Create a dictionary entry for name. If
\G the data-space pointer is not aligned, reserve enough data space
\G to align it.
: HEADER        ( "name" | c-addr u -- )        \ EXTRA
        ALIGN POSTFIX INVERT
        IF      BL PARSE-WORD DUP 0= #-16 ?ERROR
        THEN
        HEAD,
        ;

\G Make the last made dictionary entry known to the Forth system.
: REVEAL        ( -- )                          \ EXTRA
        LAST 2@ SWAP VOC!
        ;

:ORPHAN SET-HEADER-FLAGS
        HEAD?
        IF      LAST @ HEAD>FLAGS TUCK H@ OR SWAP H! EXIT
        THEN
        DROP
        ;

FORTH:

\G Mark the most recently created definition as an immediate word.
: IMMEDIATE     ( -- )                          \ FORTH
        =IMMEDIATE SET-HEADER-FLAGS
        ;  ANS

EXTRA:

\G Mark the most recently created definition as a private word. This
\G word can not be found after the execution of DEPRIVE .
: PRIVATE       ( -- )                          \ EXTRA
        =PRIVATE SET-HEADER-FLAGS
        ;

\G Mark the most recently created definition as a compile-only word.
\G The default interpreter issues exception -14 when an attempt is
\G made to execute the definition in interpret state.
: COMPILE-ONLY  ( -- )                          \ EXTRA
        =COMP SET-HEADER-FLAGS
        ;

\G Mark the most recently created definition as a standard word.
\G When the variable ANSI does not contain zero, the default
\G interpreter issues a warning if words that are not marked are
\G interpreted or compiled.
: ANS           ( -- )                          \ EXTRA
        =ANSI SET-HEADER-FLAGS
        ;

\G Mark the most recently created definition as a hidden word.
\G It can not be found by words like ' FIND and ['] .
: HIDDEN        ( -- )                          \ EXTRA
        =HIDDEN SET-HEADER-FLAGS
        ;

\G Start beginning of a PRIVATES .. DEPRIVE block.
: PRIVATES      ( -- )                          \ EXTRA
        ;

INTERNAL:

\ Hide the words in the word list wid that are marked with PRIVATE
: DEPRIVE-WORDLIST      ( wid -- )
        VOC@
        BEGIN   ?DUP
        WHILE   DUP HEAD>FLAGS H@ =PRIVATE AND
                IF      DUP HEAD>FLAGS DUP H@
                        =PRIVATE INVERT AND =HIDDEN OR
                        SWAP H!
                THEN
                H@
        REPEAT
        ;

EXTRA:

\G Hide all the words that are marked with PRIVATE .
: DEPRIVE       ( -- )                          \ EXTRA
        VOC-LINK
        BEGIN   DUP DEPRIVE-WORDLIST @ ?DUP 0=
        UNTIL
        ;

\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a definition for name with the semantics defined for the
\G execution token xt. Attributes like IMMEDIATE and COMPILE-ONLY
\G are not borrowed from xt.
: ALIAS         ( xt "name" -- )                \ EXTRA
        BL PARSE-WORD DUP 0= #-16 ?ERROR
        HEAD, REVEAL LAST @ 3 CELLS + H!        \ patch HEAD> field
        ;

\G Skip leading space delimiters. Parse name delimited by a space.
\G Return the word list identification wid of the methods of name.
\G See also: METHODS
: FIND-METHODS          ( "name" -- wid )       \ EXTRA
        ' >BODY @
        BEGIN   DUP CELL+ SWAP L@
                DUP ['] (EXIT) = #-516 ?ERROR
                ['] MODIFY =
        UNTIL
        L@
        ;

\G Skip leading space delimiters. Parse name1 delimited by a space.
\G Skip leading space delimiters. Parse name2 delimited by a space.
\G Copy the methods list of name1 to the methods list of name2.
\G Any methods defined for name2 are lost.
\G See FIND-METHODS METHODS
: INHERIT               ( "name1" "name2" -- )  \ EXTRA
        FIND-METHODS VOC@
        FIND-METHODS VOC!
        ;

INTERNAL:

0 VALUE IN-METHODS        \ A value that is not zero during defining methods.

: F:METHODS
        BODY> @+ SET-CURRENT
        2@ VOC!
        ;  COMPILE-ONLY

EXTRA:

\G Skip leading space delimiters. Parse name delimited by a space.
\G Start defining methods for name.
\G See also: END-METHODS INHERIT
: METHODS               ( "name" -- )                   \ EXTRA
        IN-METHODS CLEAR IN-METHODS #-530 ?ERROR
        S" " HEAD, REVEAL HIDDEN
        ['] F:METHODS LAST @ HEAD>FORGET H!
        HERE
        GET-CURRENT ,
        FIND-METHODS DUP SET-CURRENT DUP , VOC@ ,
        TO IN-METHODS
        ;

\G Terminate defining methods.
\G See also: METHODS
: END-METHODS           ( -- )                          \ EXTRA
        IN-METHODS 0= #-517 ?ERROR
        IN-METHODS @ SET-CURRENT
        CLEAR IN-METHODS
        ;

\G Skip leading space delimiters. Parse name delimited by a space.
\G Append the semantics of execution token xt to the forget method
\G of name.
: IS-FORGET             ( xt "name" -- )         \ EXTRA
        FIND-METHODS !
        ;

LABEL NameID
20 ALLOT

\G c-addr u specify a character string that represents the name of
\G the definition with dictionary entry address dea. If dea is zero
\G the string contains "{NoName}" and when the name is found but the
\G length of it is zero, the string contains "{NullName}". u is
\G limited to 31.
: (.HEAD)       ( dea -- c-addr u )                 \ EXTRA "paren-dot-head"
        ?DUP                                            \ Has a name
        IF      HEAD>NAME HSEG SWAP COUNTX 1F MIN DUP   \ Not zero length
                IF      -1 /STRING                      \ Include count byte
                        CSEG (LIT) NameID
                        ROT CMOVEX                      \ Make copy of string
                ELSE    2DROP DROP                      \ Discard string
                        S" {NullName}"                  \ Has zero length
                        (LIT) NameID PLACE
                THEN
        ELSE    S" {NoName}"                            \ Has no name
                (LIT) NameID PLACE
        THEN
        (LIT) NameID COUNT                              \ Return string
        ;

FORTH:

                            \ (* End of Source *) /
