\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : Meta compiler for CHForth version 1.1.0 
\ FILENAME    : FINISH.FRT 
\ DESCRIPTION : The last kernel routines, SAVE and BYE 
\ AUTHOR      : Coos Haak, Utrecht 
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



ORPHAN LOADSEGS
                PUSH    ES
                PUSH    DI
                PUSH    SI
                PUSH    BX
                MOV     AX, frtseg
                ADD     AX, segstart
                ADD     AX, segsize
                MOV     T' _DP AX
                MOV     AX, frtseg
                ADD     AX, frtmax
                ADD     AX, fullsize
                MOV     T' _HDP AX
                MOV     DI, ^SEGS
        BEGIN
                MOV     AX, -1 CELLS [DI]
                SUB     T' _DP AX
                MOV     AX, -2 CELLS [DI]
                SUB     T' _HDP AX
                MOV     AX, T' _HDP
                MOV     -3 CELLS [DI], AX
                MOV     CX, -1 CELLS [DI]
        CNZ IF
                MOV     BX, T' _DP
                MOV     DX, T' _HDP
                DEC     BX
                DEC     DX
                ADD     BX, CX
                ADD     DX, CX
                PUSH    DI
                PUSH    DS
                STD
        DO
                PUSH    CX
                MOV     CX, # 8
                MOV     SI, # E
                MOV     DI, SI
                MOV     DS, BX
                MOV     ES, DX
                REP     MOVSW
                DEC     BX
                DEC     DX
                POP     CX
        LOOP
                CLD
                POP     DS
                POP     DI
        THEN
                MOV     CX, -2 CELLS [DI]
                SUB     CX, -1 CELLS [DI]
        CNZ IF
                MOV     DX, T' _HDP
                ADD     DX, -1 CELLS [DI]
                XOR     AX, AX
                PUSH    DI
        DO
                PUSH    CX
                MOV     CX, # 8
                MOV     ES, DX
                XOR     DI, DI
                REP     STOSW
                INC     DX
                POP     CX
        LOOP
                POP     DI
        THEN
                MOV     DI, 0 [DI]
                TEST    DI, DI
        0= UNTIL
                POP     BX
                POP     SI
                POP     DI
                POP     ES
                RET
        $EVEN
END-CODE

:ORPHAN GO4TH
        (RESET) -2 SET-ORDER DEFINITIONS
        HANDLE-0 /HANDLE HANDLES * ERASE
        TERMINAL
        S" COMSPEC=" SEARCH-ENVIRONMENT COMSPEC PLACE
        COMSPEC COUNT + C0!                             \ Make ASCIIZ string
        BIOS-IO ?AT AT-XY START SIGNON @
        IF      .SIGNON CFG COUNT 2DUP FILE-STATUS NIP 0=
                IF      ['] INCLUDED CATCH ?DUP
                        IF  .MESS .WHERE ERROR-TYPE MARK-WORD
                            BYE
                        THEN
                ELSE    (LIT) (my-name) 4 SEARCH-ENVIRONMENT 2DUP
                        BEGIN   2DUP '\' SCAN DUP
                        WHILE   2NIP 1 /STRING
                        REPEAT
                        2DROP NIP - TEMPORARY PACK APPEND
                        TEMPORARY COUNT FILE-STATUS NIP 0=
                        IF  TEMPORARY COUNT ['] INCLUDED CATCH ?DUP
                            IF  .MESS .WHERE ERROR-TYPE MARK-WORD
                                BYE
                            THEN
                        THEN
                THEN
        THEN
        TIMER-RESET                                     \ reset timer
        TIMESAVE 2@ TIMESAVE 2 CELLS + 2!               \ and diagnose timer
        LINESREAD OFF THEFILE OFF
        HERE BYTES ! LHERE LBYTES ! HHERE HBYTES !
        80 C@ (LIT) cold C!
        CLEAR RESTART? COLD
        ;

LABEL INITMESS
        S" Not enough memory to start CHForth program " S,-T
LABEL INITNAME
        S" Kernel  " S,-T
        ^M C, ^J C, '$' C,

ORPHAN INITIAL          TH> T.INITIAL

                MOV     frtseg CS

                MOV     AX, 2C
                MOV     envseg AX
                DEC     AX                      \ arena header
                MOV     DS, AX
                MOV     AX, 3                   \ size of block
                XOR     AH, AH                  \ delimit to 4096 bytes
                PUSH    CS
                POP     DS
                MOV     envmax AX

                MOV     BX, frtmax
                ADD     BX, fullsize
                MOV     AH, # 4A
                INT     21
        U< IF
                MOV     DX, INITMESS #
                MOV     AH, # 9
                INT     21
                MOV     AX, # 4C01
                INT     21
        THEN
                CLD
                MOV     AX, # 3300          \ get break flag
                INT     21
                MOV     SBRK [], DL
                MOV     AX, # 3301          \ set break flag
                XOR     DL, DL              \ off
                INT     21

                MOV     AX, # 3500          \ divide trap
                INT     21
                MOV     SYS-DIV BX          \ keep old value
                MOV     SYS-DIV CELL+ ES
                MOV     DX, # PTR DIVERR    \ set new value
                MOV     AH, # 25
                INT     21

                MOV     AX, # 3506          \ opcode trap
                INT     21
                MOV     SYS-OPC BX          \ keep old value
                MOV     SYS-OPC CELL+ ES
                MOV     DX, # PTR OPCERR    \ set new value
                MOV     AH, # 25
                INT     21

                MOV     AX, # 351B          \ BIOS break
                INT     21
                MOV     SYS-BRK BX          \ keep old value
                MOV     SYS-BRK CELL+ ES
                MOV     DX, # BIOSBK        \ set new value
                MOV     AH, # 25
                INT     21

                MOV     AX, # 351C          \ system clock
                INT     21
                MOV     SYS-CLK BX          \ keep old value
                MOV     SYS-CLK CELL+ ES

                MOV     DX, # DOSBK         \ set DOS break
                MOV     AX, # 2523
                INT     21

                PUSH    CS
                POP     ES
                CALL    metrics
                MOV     AL, mode []
                MOV     dftm [], AL
                MOV     AH, # 8
                PUSH    SI
                PUSH    BP
                INT     10
                POP     BP
                POP     SI
                MOV     AL, AH
                MOV     T' ATTR [], AL
                MOV     T' ATT0 [], AL
                MOV     BP, SP
                SUB     BP, # 80
                MOV     catcher # 0
                CALL    LOADSEGS
                MOV     ES, lstseg
                MOV     AX, # GO4TH
                JMP     AX
END-CODE

LABEL exehead
        5A4D ,  \ 'MZ'
LABEL exelen
        0 ,     \ lengte modulo 512
        0 ,     \ lengte div 512
        0 ,     \ relocatie aantal
        2 ,     \ lengte header in para's
        0 ,     \ minimaal geheugen
        FFFF ,  \ maximaal geheugen
        FFF0 ,  \ stacksegment
LABEL exestack
        FFFC ,  \ stackoffset
        0 ,     \ checksum
INITIAL ,       \ ip
        FFF0 ,  \ cs
        1C ,    \ offset tabel
        0 ,     \ overlay nummer
        0 ,     \ eerste relocatie
        0 ,     \ vulsel

EXTRA:

\G Skip leading space delimiters. Parse name delimited by a space.
\G Protect the dictionary as with EXTEND . Write the CHForth program
\G as an executable file with this name. name may have a preceding
\G path but no extension. The current settings of LIMIT and MEMTOP
\G are preserved as are their equivalents in other segments.
: SAVE          ( "name" -- )                       \ EXTRA
        LHERE #PARAGRAPHS (LIT) lstlen !
        HHERE DUP (LIT) ENDHEADS ! #PARAGRAPHS (LIT) hdrlen !
        HERE FENCE !
        HERE PARAGRAPH-ALIGNED 0FC + (LIT) exestack !
        HERE #PARAGRAPHS 10 + (LIT) segstart !
        MEMTOP #PARAGRAPHS (LIT) frtmax !           \ trim CSEG
        LMEMTOP #PARAGRAPHS (LIT) lstmax !          \ trim LSEG
        HMEMTOP #PARAGRAPHS (LIT) hdrmax !          \ trim HSEG
        THEFILE OFF
        (LIT) segsize OFF (LIT) fullsize OFF
        (LIT) ^SEGS @
        BEGIN   DUP CELL- @ (LIT) segsize +!
                DUP CELL- CELL- @ (LIT) fullsize +!
                @ ?DUP 0=
        UNTIL
        HERE PARAGRAPH-ALIGNED 20 + 0 (LIT) segsize @ 10 UM* D+ 200 UM/MOD
        OVER 0<> - SWAP (LIT) exelen 2!
        S" .exe" BL WORD APPEND

        (LIT) INITNAME 8 BLANK
        HERE COUNT LOCAL u LOCAL a
        BEGIN   a u '\' SCAN DUP
        WHILE   1 /STRING TO u TO a
        REPEAT
        2DROP a u '.' SCAN NIP ?DUP
        IF      u SWAP -
        ELSE    u
        THEN
        8 UMIN a (LIT) INITNAME ROT CMOVE

        HERE COUNT W/O BIN CREATE-FILE THROW >R
        (LIT) exehead 20 R@ WRITE-FILE THROW
        HERE 110 ERASE 100 HERE PARAGRAPH-ALIGNED R@ WRITE-FILE THROW
        (LIT) ^SEGS CELL+ @ TO a
        BEGIN   -2 a []CELL @
                IF      -4 a []CELL @ -2 a []CELL @ R@ WRITEP THROW
                THEN
                a @ DUP TO a 0=
        UNTIL
        R> CLOSE-FILE THROW
        ;

\G Terminate the Forth program and return to the operating system
\G with returncode n.
: HALT          ( n -- )                        \ EXTRA
        RETCODE ! ERRNAME OFF ATEXIT ((BYE))
        ;

FORTH:

\G Terminate the Forth program and return to the operating system
\G with returncode zero.
: BYE           ( -- )                          \ FORTH
        0 HALT
        ;  ANS

EXTRA:

:ORPHAN (TURNKEY)
        RESTART? INVERT
        IF      ['] NOOP CATCH
        THEN
        BYE
        ;

HERE-L 5 CELLS - MCONSTANT [TURNKEY]

\G Skip leading space delimiters. Parse name1 delimited by a space.
\G Skip leading space delimiters. Parse name2 delimited by a space.
\G Protect the dictionary as with EXTEND . Write the CHForth program
\G as an executable file with this name2. name2 may have a preceding
\G path but no extension.
\G
\G The saved file does not contain any headers, so interpreting in
\G the executible file is not possible. The data space and list
\G space will also be reduced to the minimum value that is needed to
\G containt the current data in the data and list space. Both spaces
\G can be enlarged before executing this word.
\G
\G When this program is executed from the DOS prompt, name1 will be
\G executed by CATCH and at the end the control will be returned to
\G DOS. The program saved has no capability to compile and has no
\G headers.
: TURNKEY       ( "name1" "name2" -- )  \ EXTRA
        RETCODE @ #-521 ?ERROR          \ Some FORWARDs were compiled
        DIAGNOSE                        \ Show the compiled space
        SIGNON OFF                      \ No need to display program name
                                        \ or load .CFG file
        MEMTOP #PARAGRAPHS 1000 =       \ Limit unchanged ?
        IF      0 RESERVE               \ Trim code segment
        THEN                            \ keep PAD + TEMPORARY
        LMEMTOP #PARAGRAPHS 1000 =      \ List limit unchanged ?
        IF      0 LRESERVE              \ Trim list segment
        THEN                            \ keep PAD + TEMPORARY
        HDP OFF (LIT) hdrmax OFF        \ Discard headers
        CLEAR HMEMTOP                   \ No headers in file
        ' (LIT) T[ [TURNKEY] ,-L T] L!
        (LIT) (TURNKEY) IS COLD
        SAVE RETCODE @ HALT
        ;

FORTH:

LABEL EndOfSource

SETVECTOR STATUS        NOOP
SETVECTOR COLD          DFTCOLD
SETVECTOR DIAGNOSE      NOOP
SETVECTOR DOFORGET      (DOFORGET)
SETVECTOR START         RANDOMTIMER
SETVECTOR KEY           (KEY)
SETVECTOR EMIT          (EMIT)
SETVECTOR NUMBER?       (NUMBER?)
SETVECTOR PROMPT        (PROMPT)
SETVECTOR BEEP          STDBEEP
SETVECTOR ATEXIT        NOOP
SETVECTOR PAUSE         NOOP
SETVECTOR 'INTERPRET    $INTERPRET
SETVECTOR 'COMPILE      $COMPILE
SETVECTOR READ-BLOCK    NOT-IMPLEMENTED
SETVECTOR WRITE-BLOCK   NOT-IMPLEMENTED
SETVECTOR +BUF          NOT-IMPLEMENTED
SETVECTOR UPDATE        NOT-IMPLEMENTED
SETVECTOR ?CRASH        THROW
SETVECTOR LOG-ERROR     NOOP
SETVECTOR 'ACCEPT       MINIACCEPT
SETVECTOR LOG-EMIT      DROP
SETVECTOR LOG-TOGGLE    NOOP

HERE    T' FENCE !-T
HERE    T' BYTES !-T
HERE    T' DP !-T

HERE-L  T' LBYTES !-T
HERE-L  T' LDP !-T

^MMESS @ T' MESS-LINK !-T

HERE-H  PTR ENDHEADS !-T
HERE-H  T' HBYTES !-T
HERE-H  T' HDP !-T

^MVECT @ PTR ^VECT !-T

<FORTH>    VOC@ T' FORTH    CELL+ !-T
<EXTRA>    VOC@ T' EXTRA    CELL+ !-T
<EDITOR>   VOC@ T' EDITOR   CELL+ !-T
<INTERNAL> VOC@ T' INTERNAL CELL+ !-T
<ONLY>     VOC@ T' ONLY     CELL+ !-T

                            \ (* End of Source *) /
