\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Configuration of the computer memory 
\ CATEGORY    : Debugging 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1993, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -assembler

?def -mem [if] -mem [then]

        MARKER -mem


        NEEDS -quicksort

        NEEDS -arrays

hex

privates

80 constant #ints       private

FFFE constant _top      private

2array row

code scanx
                mov     dx, es
                mov     cx, # -1
                pop     di
                pop     es
                mov     al, bl
                repnz   scasb
                mov     bx, di
                push    es
                mov     es, dx
                next
end-code  private

code lenz
                pop     ds
                mov     ax, bx
        0 $:    test    0 [bx], # FF
                jz      1 $
                inc     bx
                jmp     0 $
        1 $:    push    ds
                push    ax
                sub     bx, ax
                cmp     bx, # FF
                jle     2 $
                mov     bx, # FF
        2 $:    mov     ax, cs
                mov     ds, ax
                next
end-code  private

: seg.
        push base decimal
        #16 um* 2dup #1000. d<
        if      8 d.r
        else    <# # # # ',' hold #s #> 8 over - spaces type
        then
        ."  bytes. "
        pop base
        ;  private

: .ints
        100 0
        do      0 i 2* 1+ 2* @x over =
                if      i b.
                then
        loop
        drop
        ;

create comparand 2 cells allot  private

: (cpd@)
        comparand 2@
        ;  private
        ' (cpd@) is qs_comparand

: (cpd!)
        comparand 2!
        ;  private
        ' (cpd!) is qs_save

: (get)
        row
        ;  private
        ' (get) is qs_get

: (put)
        to row
        ;  private
        ' (put) is qs_put

\ (cmp) is geen du< !!

: (cmp)
        pluck over u<
        if      2drop 2drop true exit
        then
        rot =
        if      u<
        else    2drop false
        then
        ;  private
        ' (cmp) is qs_compare

: allints
        -1 local segment #ints 0
        do      i dup get-interrupt drop i to row
        loop
        0 #ints 1- quick
        cr ."    + interrupt return   - nil pointer   x zero value"
        #ints 0
        do      i row dup segment <>
                if      cr dup to segment h. 8 htab
                else    drop
                then
                out 5 + c/l >
                if      cr 8 htab
                then
                dup get-interrupt c@x CF =
                if      '+' emit
                else    dup get-interrupt or 0=
                        if      '-' emit
                        else    dup get-interrupt @x 0=
                                if      'x' emit
                                else    space
                                then
                        then
                then
                b. stop? ?leave
        loop
        reset row
        ;

internal

: mcb
        local segment 0 local geheugen 0
        begin   dup 0 c@x 'M' =
                if      dup 1 @x segment =
                        if      cr dup 1+ h. 8 htab dup 3 @x dup dup 1+
                                +to geheugen h. seg. dup 1+
                                case
                                        segment 2C @x of
                                                ." environment"  endof
                                        segment of
                                                ." codesegment "
                                                dup 1+ .ints    endof
                                        hseg of
                                                ." headers"      endof
[ ?def logseg ] [if]
                                        logseg @ of
                                                ." logsegment"   endof
[then]
                                endcase
                                dup 3 @x +
                        then
                then
                1+ dup _top u>
        until
        drop geheugen
        if      cr ." Total   " geheugen h. geheugen seg.
        then
        ;

: zcb
        0 mcb
        ;

: hcb
        cseg mcb
        ;

forth

code (psp)
        0 $:    mov     ds, bx
                cmp     50 [], # 21CD
                jnz     1 $
                cmp     52 [], # CB byte
                jnz     1 $
                mov     ax, cs
                mov     ds, ax
                push    bx
                mov     bx, # true
                next
        1 $:    inc     bx
                cmp     bx, # _top
                jbe     0 $
                mov     ax, cs
                mov     ds, ax
                xor     bx, bx
                next
end-code  private

: .params
        dup 80 c@x 1+ 80 u<
        if      dup 81 c@x ^M =
                if      drop
                else    80 countx stypex
                then
        else    drop
        then
        ;  private

0 value n

: .view
        (psp) 0=
        if      true abort" Too high in memory"
        then
        dup>r 2C @x dup to n
        if      n 1- 0 c@x 'M' = n 1- 1 @x r@ = and
                if      n 0 cr
                        begin   2dup typez lenz + 1+ cr countx ?dup
                        while   emit
                        repeat
                        2dup @x 1 =
                        if      2 + typez
                        else    2drop
                        then
                then
                cr r@ 1- 8 lenz 8 min stypex r@ .params
        then
        r@ mcb r> 1+ to n
        ;

: -view
        (psp) 0=
        if      true abort" Too high in memory"
        then
        dup>r 2C @x dup to n
        if      cr r@ 1- 8 lenz 8 min stypex r@ .params
        then
        r@ mcb r> 1+ to n
        ;

: specs
        0
        begin   (psp)
        while   cr dup h. 8 htab dup 2C @x
                if      dup 2C @x 0
                        begin   0 scanx countx 0=
                        until
                        2drop dup 1- 8 lenz 8 min stypex
                then
                dup .params #50 htab dup .ints 1+
        repeat
        ;

internal

: .env
        eseg 0
        begin   cr
                begin   countx ?dup
                while   emit
                repeat
                2dup c@x 0=
        until
        2drop
        ;

forth

: .ports
        push base hex
        8 0
        do      40 i @x ?dup
                if      cr ." COM" i 2/ 1+ . ." = " .
                then
        2 +loop
        10 8
        do      40 i @x ?dup
                if      cr ." LPT" i 8 - 2/ 1+ . ." = " .
                then
        2 +loop
        pop base
        ;

: .roms
        0 C000
        do      i 0 @x AA55 =
                if      cr ." Rom  at " i h. ." size " i 2 c@x 2/ .dec ." Kb"
                then
                i 0 @x 55AA =
                if      cr ." Bios at " i h. ." size " i 2 c@x 2/ .dec ." Kb"
                then
        80 +loop
        ;

: .name         ( seg ofs max -- )
        false local end
        bounds
        do      end
                if      space
                else    dup i c@x dup bl $7F within
                        if      emit
                        else    drop space true to end
                        then
                then
        loop
        space drop
        ;  private

: kb.           ( d -- )
        push base decimal
        2dup #1024 s>d du<
        if      5 d.r ."  bytes. "
        else    >r #10 um* r> #10 um* drop +
                #1024 um/mod nip u>d
                <# # '.' hold #s #> 5 over - spaces type ."  Kbytes. "
        then
        pop base
        ;  private

: .blocks       ( -- )
        0 0
        do      i 0 c@x 'A' [ 'Z' 1+ ] literal within
                if      i 1 @x i 1+ =
                        if      cr
                                i 0 c@x case
                                        'B' of  ." Buffers  = " endof
                                        'D' of  ." Device   = " endof
                                        'F' of  ." Files    = " endof
                                        'L' of  ." Lastdrive= " endof
                                        'M' of  ." Program  = " endof
                                        'X' of  ." Fcbs     = " endof
                                        'Z' of  ." Umbs     = " endof
                                                ." Unknown  = "
                                endcase
                                i 8 8 .name
                                i 1 @x h.
                                i 3 @x #16 m* kb.
                        then
                then
                stop? ?leave
        loop
        ;

: .drivername   ( x-addr -- )
        2dup 4 + @x 0<
        if      A + 8 .name
        else    2dup B + 7 .name A + c@x dup . ." unit" 1 =
                if      ."   "
                else    ." s "
                then
        then
        ;  private

code list-of-lists
                push    bx
                mov     cx, es
                mov     ah, # 52
                int     21
                push    es
                mov     es, cx
                next
end-code

: .subst
        'A' local drive
        list-of-lists 18 + @x local seg 0 local ofs
        begin   seg ofs c@x 'A' '[' within
        while   seg ofs 1+ c@x ':' =
        while   cr drive emit ." : => " seg ofs 44 + c@x
                if      seg ofs typez #40 htab
                        seg ofs 45 + 2@x x.
                        seg ofs 49 + @x dup 1+
                        if      h.
                        else    drop ." Not accessed"
                        then
                else    ." Not connected"
                then
                58 +to ofs 1 +to drive
        repeat
        then
        ;

create data  private
        'C' c, 'S' c, 'B' c, '?' c,
        'R' c, '?' c, '?' c, '?' c,
        'x' c, 'L' c, '?' c, 'x' c,
        'K' c, 'N' c, 'O' c, 'I' c,

: attributes
        10 0
        do      dup 0<
                if      i data + c@
                else    bl
                then
                emit
                2*
        loop
        drop space
        ;  private

: .drivers
        list-of-lists 22 +
        begin   cr over 1- over c@x dup 'M' = swap 'D' = or
                if      over 1- over 8 + 8 .name
                else    9 spaces
                then
                2dup x. 2dup .drivername
                #36 htab 2dup 4 + @x attributes
                2dup 6 + @x h. 2dup 8 + @x h.
                2@x dup -1 = stop? or
        until
        2drop
        ;

: .irqs
        10 0
        do      cr ." IRQ " i push base decimal 2 .r space pop base
                i 8 <
                if      i 8 +
                else    i 68 +
                then
                ."  INT " dup b. space
                get-interrupt over swap x.
                1- 8 8 .name
        loop
    ;

deprive

                            \ (* End of Source *) /
