\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : The game of LIFE 
\ CATEGORY    : Games 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        MARKER -life


?def clk.int [if]

clockoff

[then]

?def ;code [if]

: rechthoek
        create  1 cells allot
        ;code
                mov     di, ax
                mov     di, 0 >body [di]
$if386
                imul    bx, 0 [di]
                pop     ax
$else
                mov     ax, 0 [di]
                mul     bx
                pop     bx
$then
                add     bx, ax
                lea     bx, 2 [bx+di]
                next    end-code

[else]

: rechthoek
        create  1 cells allot
        does>   @ @+ rot * + []char
        ;

[then]

rechthoek [oud]
rechthoek [nieuw]

vector oud
vector nieuw

' [oud] is oud
' [nieuw] is nieuw

: buren
        0 local teller
        over 1- over 1- oud c@ +to teller
        over 1- over    oud c@ +to teller
        over 1- over 1+ oud c@ +to teller
        over    over 1- oud c@ +to teller
        over    over 1+ oud c@ +to teller
        over 1+ over 1+ oud c@ +to teller
        over 1+ over    oud c@ +to teller
        1- swap 1+ swap oud c@ teller +
        ;

?def code [if]

code c1!
                mov     0 [bx], # 1 byte
                pop     bx
                next    end-code

[else]

: c1!
        1 swap c!
        ;

[then]

: test
        2dup oud c@
        if      2dup buren dup 2 <
                if      drop nieuw c0! exit
                then
                3 >
                if      nieuw c0! exit
                then
                nieuw c1! exit
        then
        2dup buren 2 >
        if      nieuw c1! exit
        then
        nieuw c0!
        ;

: kopie
        push oud
        push nieuw
        pop oud
        pop nieuw
        ;

variable at'

: home
        at' off
        ;

: emit
        $1E join $B800 at' @ !x 2 at' +!
        ;

: rows
        l/scr 2 +
        ;

: cls
        home rows 1+ c/l * 0
        do      bl emit
        loop
        ;

: nl
        at' @ c/l 2* tuck mod - at' +!
        ;

: display
        home rows 1
        do      c/l 1- 1
                do      j i nieuw c@
                        if      ''
                        else    bl
                        then
                        emit
                loop
                nl
        loop
        ;

: geheugen
        here rows 1+ , here rows 1+ c/l * dup allot erase
        ;

: go
        cls hide-cursor
        geheugen ['] [oud] >body !
        geheugen ['] [nieuw] >body !
        c/l 2 - 1
        do      1 rows 1- choose 1+ i oud c!
                1 rows 1- choose 1+ i oud c!
        loop
        rows 1- 1
        do      1 i c/l 2 - choose 1+ oud c!
                1 i c/l 2 - choose 1+ oud c!
        2 +loop
        begin   rows 1
                do      c/l 1- 1
                        do      j i test
                        loop
                loop
                display kopie key?
        until
        key drop show-cursor
        ['] [oud] >body @
        ['] [nieuw] >body @
        umin [ internal ] dp [ forth ] !
        ;

: .help
        CR CR ."      Type 'GO' to run the simulation." CR
        ;

.help

                            \ (* End of Source *) /
