\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : String package with memory allocation 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -memory

        MARKER -strings



: init-mem
        true abort" did you really think that?"
        ;

( ^hdl -- adr len )
: $@
        @ dup @ swap allocated
        flyer postpone sliteral
        ;

( adr len ^hdl -- )
: $!
        dup>r @ free ?allocate
        allocate ?allocate
        dup r@ ! @ r> @ allocated cmove
        ;

( adr len ^hdl -- )
: $+!
        dup>r $@ drop 1- dup>r append r> count r> $!
        ;

( ^hdl -- )
: $0!
        dup @ 0 resize ?allocate swap !
        ;

prefix length

prefix items

prefix new$array

: string
        create  0 allocate ?allocate ,
        does>   $@
        ;

:noname
        @ free ?allocate
        ;  is-forget string

methods string

: to
        postpone literal postpone $!
        ;

: +to
        postpone literal postpone $+!
        ;

: clear
        postpone literal postpone $0!
        ;

: adr
        postpone literal postpone @ postpone @
        ;

: length
        postpone literal postpone @ postpone allocated
        ;

: items
        drop 1 postpone literal
        ;

end-methods

: $array
        create  dup , 0
                do      0 allocate ?allocate ,
                loop
        does>   cell+ []cell $@
        ;

:noname
        @+ 0
        do      @+ free ?allocate
        loop
        drop
        ;  is-forget $array

privates

: []$array
        inline# cell+ []cell
        ;  private

methods $array

: to
        postpone []$array l, postpone $!
        ;

: +to
        postpone []$array l, postpone $+!
        ;

: clear
        postpone []$array l, postpone $0!
        ;

: adr
        postpone []$array l, postpone @ postpone @
        ;

: length
        postpone []$array l, postpone @ postpone allocated
        ;

: items
        postpone literal postpone @
        ;

: new$array
        true abort" Can't resize string array"
        ;

end-methods

deprive

                            \ (* End of Source *) /
