\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : String package with garbage collector 
\ CATEGORY    : Utilities 
\ AUTHOR      : Kees Moerman 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -assembler

        MARKER -string



privates

: link,
        here over @ , swap !
        ;  private

align
here dup #2000 dup allot erase
here constant ^max      private
     constant ^min      private

variable ^link  ^link off       private

^min value ^free        private

code .blink
                next
end-code  immediate  private

code .cnt
                add     bx, # 1 cells
                next
end-code  private

code .data
                add     bx, # 2 cells
                next
end-code  private

align
here ^link link, 0. 2,
     ^link link, 0. 2, cell+ constant parrs     private

code link
                pop     di
                mov     0 [di], bx
                mov     0 [bx], di
                pop     bx
                next
end-code  private

code bind$
                add     bx, # parrs
                pop     di
                mov     cx, di
                mov     di, 0 [di]
                mov     di, 0 [di]
                xchg    cx, di
                cmp     cx, di
        0= if
                mov     0 [bx], # 0
                mov     ax, 0 [di]
                mov     1 cells [bx], ax
        else
                mov     1 cells [bx], # 0
                mov     0 [bx], di
                mov     0 [di], bx
        then
                pop     bx
                next
end-code  private

code free$
                mov     parrs [bx], # 0
                pop     bx
                next
end-code  private

code par$
                add     bx, # parrs
                mov     ax, 1 cells [bx]
                test    ax, ax
        0<> if
                mov     bx, ax
        then
                mov     bx, 0 [bx]
                next
end-code  private

code init-space
                mov     di, ^link
        begin
                mov     di, 0 [di]
                test    di, di
        0<> while
                mov     1 cells [di], # 0
        repeat
                mov     adr ^free # ^min
                next
end-code  private

code valid-adr?
                mov     ax, bx
                xor     bx, bx
                cmp     ax, # ^min
        u>= if
                cmp     ax, # ^max
        u< if
                dec     bx
        then
        then
                next
end-code  private

: mark
        ^link
        begin   @ ?dup
        while   dup cell+ @ dup valid-adr?
                if      dup .cnt dup @ $8000 or swap !
                then
                drop
        repeat
        ;  private

code ?mark
                mov     ax, 1 cells [bx]
                test    ax, ax
        0< if
                and     1 cells [bx], # $7FFF
                mov     bx, # true
        else
                xor     bx, bx
        then
                next
end-code  private

: cleanup_heap
        ^min dup mark
        begin   dup ^free u<
        while   dup ?mark
                if      2dup -
                        if      2dup tuck .cnt @ cell+ cell+ move
                                over dup .blink @ !
                        then
                        over .cnt @ cell+ cell+ rot over + -rot +
                else    dup .cnt @ cell+ cell+ +
                then
                dup valid-adr? invert
                if      init-space true abort" Illegal string"
                then
        repeat
        drop to ^free
        ;  private

: allocate
        dup
        if      dup cell+ cell+ ^free + ^max u< invert
                if      cleanup_heap
                then
                dup cell+ cell+ ^free + ^max u< invert
                if      0 free$ 6 free$ true abort" Stringspace full"
                then
                ^free over cell+ cell+ +to ^free tuck .cnt ! dup .blink off
        then
        ;  private

: "" 0
        ;

code "len
                test    bx, bx
        0<> if
                mov     bx, 1 cells [bx]
        then
                next
end-code

code "count
                lea     ax, 2 cells [bx]
                push    ax
                test    bx, bx
        0<> if
                mov     bx, 1 cells [bx]
        then
                next
end-code

: "type
        "count type
        ;

: "+
        over 0=
        if      swap
        then
        ?dup
        if      2dup 6 bind$ 0 bind$ "len swap "len + allocate >r
                0 par$ "count r@ .data swap cmove
                6 par$ "count r@ "count + over - swap cmove
                0 free$ 6 free$ r>
        then
        ;

: strput
        dup off over
        if      swap dup dup .blink @ @ =
                if      dup "len allocate swap .data
                        over "count move
                then
                link
        else    !
        then
        ;  private

: strcat
        dup @ rot "+ link
        ;  private

: string
        create  ^link link, 0 ,
        does>   cell+ @
        ;

prefix length

methods string

: to
        cell+ postpone literal postpone strput
        ;

: +to
        cell+ postpone literal postpone strcat
        ;

: clear
        cell+ postpone literal postpone off
        ;

: adr
        cell+ postpone literal postpone @ postpone .data
        ;

: length
        cell+ postpone literal postpone @ postpone "len
        ;

end-methods

also internal

:noname
        chain doforget
        ^link dup>r
        begin   dup @ dup
        while   dup here u>
                if      dup @ r@ !
                then
                cleanup_heap nip
        repeat
        2drop r>drop
        ;  is doforget

previous

: (")
\       r> dup "count + aligned >r ;
        inline#
        ;  private

: here>"
        here count allocate swap over "count cmove
        ;

: "
        state @
\       if      postpone (") 0 , here 0 ,
        if      postpone (") here l, 0 , here 0 ,
                '"' parse-word tuck here swap cmove tuck allot ! align
        else    '"' word drop here>"
        then
        ;  immediate

: "blank
        dup
        if      allocate dup "count blank
        then
        ;

: ?string
        over
        if      0 max dup
                if      true
                else    nip false
                then
        else    "blank swap
        then
        ;  private

: "left
        ?string
        if      swap 0 bind$ "blank dup 0 par$ "count rot "count
                rot umin move 0 free$
        then
        ;

: "mid
        dup>r over >r - ?string
        if      drop 0 bind$ r> r@ - "blank dup "count r@ 0<
                if      swap r> abs + swap 0 >r
                then
                0 par$ "count r@ - rot min swap r> + -rot 0 max move
        else    r>drop r>drop
        then
        ;

: "right
        ?string
        if      over "len dup rot - dup 0>
                if      "mid
                else    abs nip swap 0 bind$ "blank 0 par$ 0 free$ "+
                then
        then
        ;

: "center
        ?string
        if      over 6 bind$ swap "len over <
                if      dup "blank >r 6 par$ "count rot over - 2/ r@
                        .data + swap move r>
                else    6 par$ "len over - 2/ 6 par$ swap rot
                        bounds "mid
                then
                6 free$
        then
        ;

: ">here
        dup "len 255 > abort" String too long"
        "count here place ( bl here count + c! )
        ;

: ">dint
        "count number? 2 <> abort" no double precision number"
        ;

: ">int
        "count number? 1 <> abort" no single precision number"
        ;

: dint>"
        (d.) allocate tuck "count cmove
        ;

: int>"
        (.) allocate tuck "count cmove
        ;

: char>"
        1 allocate tuck .data c!
        ;

: ">char
        .data c@
        ;

: "compare
        >r "count r> "count compare
        ;

: "=
        "compare 0=
        ;

: "<
        "compare 0<
        ;

: ">
        "compare 0>
        ;

: "in
        ?dup
        if      2dup "len swap "len - 1- dup 0<
                if      true local flag abs 0
                        do      over .data i + over "count tuck compare 0=
                                if      2drop i true flag invert to flag leave
                                then
                        loop
                        flag
                        if      2drop false
                        then
                else    drop 2drop false
                then
        else    drop 0 true
        then
        ;

?def decompiler [if]

:noname
        [ decompiler ]
        cell+ '"' emit space dup cell+ swap l@ "type '"' emit space
        ;  ' (") tab!   forth

[then]

deprive
                            \ (* End of Source *) /
