\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Circular extra stack 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : June 27, 1994, Coos Haak, in assembler for speed
\ CREATED     : May 14, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -assembler

        MARKER -stack



DOC
(*
  This stack does not overflow, it just wraps to its other end.
  It is a circular buffer. Popping the maximum elements return
  the values in the same order as before.
  Remember that >R , R> and LOCAL are faster than this, even in
  assembler, because the stack is not in the stacksegment and
  "xchg sp, bp" etc. are not available.
  As I do not use this stack very much, contrary to FYSFORTH and
  iForth, I removed it from the kernel.
*)
ENDDOC

privates

$40 constant /stack                     private \ maximal depth, power of 2 !!
variable sptr                           private \ stack pointer
create stack                            private \ circular stack
        here /stack cells dup allot erase

\G ( S: -- x )
\G Push a number on the auxiliary stack.
CODE >S         ( x -- )                        \ STACK "to-s"
                inc     sptr
                mov     ax, sptr
                and     ax, # /stack 1-
                add     ax, ax
                mov     di, # stack
                add     di, ax
                mov     0 [di], bx
                pop     bx
                next
end-code

\G ( S: x -- )
\G Pop a number from the auxiliary stack.
CODE S>         ( -- x )                        \ STACK "s-from"
                push    bx
                mov     ax, sptr
                and     ax, # /stack 1-
                add     ax, ax
                mov     di, # stack
                add     di, ax
                mov     bx, 0 [di]
                dec     sptr
                next
end-code

\G ( S: x -- x )
\G Copy the top number on the auxiliary stack to the data stack.
CODE S          ( -- x )                        \ STACK
                push    bx
                mov     ax, sptr
                and     ax, # /stack 1-
                add     ax, ax
                mov     di, # stack
                add     di, ax
                mov     bx, 0 [di]
                next
end-code

\G ( S: x1 x2 -- x1 x2 )
\G Copy the second number on the auxiliary stack to the data
\G stack.
CODE T          ( -- x1 )                        \ STACK
                push    bx
                mov     ax, sptr
                dec     ax
                and     ax, # /stack 1-
                add     ax, ax
                mov     di, # stack
                add     di, ax
                mov     bx, 0 [di]
                next
end-code

\G ( S: x1 x2 x3 -- x1 x2 x3 )
\G Copy the third number on the auxiliary stack to the data
\G stack.
CODE U          ( -- x1 )                       \ STACK
                push    bx
                mov     ax, sptr
                sub     ax, # 2
                and     ax, # /stack 1-
                add     ax, ax
                mov     di, # stack
                add     di, ax
                mov     bx, 0 [di]
                next
end-code

\G ( S: x -- )
\G Drop the top number of the auxiliary stack.
CODE S>DROP     ( -- )                          \ STACK "s-drop"
                dec     sptr
                next
end-code

\G ( S: x -- )
\G Drop the top number of the auxiliary stack. An alias for
\G S>DROP .
' S>DROP ALIAS -S       ( -- )                          \ STACK "minus-s"

\G ( S: -- x1 x2 )
\G Push a pair of numbers numbers on the auxiliary stack.
: 2>S           ( x1 x2 -- )                    \ STACK "two-to-s"
        swap >s >s
        ;

\G ( S: x1 x2 -- )
\G Pop a pair of numbers numbers from the auxiliary stack.
: 2S>           ( -- x1 x2 )                    \ STACK "two-s-from"
        s> s> swap
        ;

\G ( S: -- x )
\G Duplicate a number and push it on the auxiliary stack.
: DUP>S         ( x -- x )                      \ STACK "dupe-to-s"
        dup >s
        ;

deprive

                            \ (* End of Source *) /
