\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Access to some sort of beeping device.
\ CATEGORY    : Utility
\ AUTHOR      : Marcel Hendrix
\ LAST CHANGE : May 16, 1994, Coos Haak CHForth version
\ LAST CHANGE : August 28, 1993, Marcel Hendrix added PC-NOTES
\ LAST CHANGE : June 20, 1993, Marcel Hendrix 
\ ----------------------------------------------------------------------



        MARKER -speaker



DOC
\ 
\ This will work for both iForth and tForth.
\ And also for CHForth.
\ 
ENDDOC


: SET-FREQUENCY $B6 $43  PC!                    \ <freq> --- <>
                DUP $42  PC!
                ><  $42  PC! ;

: SPEAKER-OFF   $61 PC@  $FC AND $61 PC! ;
: SPEAKER-ON    $61 PC@    3  OR $61 PC! ;

-- convert a logical note number to a frequency. Note 0 = ces0

CREATE _notes PRIVATE
        #47538 ,  #44870 ,  #42352 ,  #39975 ,  
        #37731 ,  #35613 ,  #33614 ,  #31728 ,  
        #29947 ,  #28266 ,  #26680 ,  #25182 ,  

: NOTE?         #12 /MOD SWAP                   \ <n1> --- <frequency>
                _notes []CELL @  
                SWAP RSHIFT ;


: .HELP
                CR ." <n> SET-FREQUENCY "
                CR ." SPEAKER-ON "
                CR ." SPEAKER-OFF " 
                CR ." NOTE ( n -- frequency) Where 0 <= n <= 120 " ;

                            \ (* End of Source *) /
