\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Saving and restoring the screen 
\ CATEGORY    : Kernel extensions 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Willem Ouwerkerk ( Added cursor pos )
\ ----------------------------------------------------------------------



        MARKER -screensv


extra definitions

privates

4 constant maxscreens                   private \ how many screens to save

create savedscreens                     private \ array with handles
        savedscreens maxscreens 1+ cells dup allot erase

create savedpositions                   private \ array with cursor positions
        savedpositions maxscreens 2* cells dup allot erase

#-621 mess" Screen stack overflow"

: saved                 ( -- +n )                   \ number of saved screens
        savedscreens @
    ;  private

\G Keep the contents of the screen and the cursor position in
\G memory. There is room for 4 screens. See also RESTORE-SCREEN
\G and RECOVER-SCREEN .
: SAVE-SCREEN           ( -- )                          \ SCREENSV
        saved maxscreens =                              \ too many?
        if      #-621 .mess exit                        \ wrong, but no abort
        then
        screensize #paragraphs alloc throw              \ allocate memory
        dup savedscreens @+ cells + !                   \ store pointer
        ?at saved savedpositions []double 2!            \ keep cursor position
        sbase 0 rot 0 screensize cmovex                 \ move data
        savedscreens incr                               \ prepare for next one
        ;

\G Restore the former contents of the screen and the position of
\G the cursor from memory that is saved there by SAVE-SCREEN . Do
\G not discard this data so this word can be executed more times
\G to restore the same screen. See also RESTORE-SCREEN .
: RECOVER-SCREEN        ( -- )                          \ SCREENSV
        saved                                           \ only when saved
        if      savedscreens @+ 1- cells + @
                0 sbase 0 screensize cmovex             \ move data
            saved 1- savedpositions []double 2@ at-xy   \ reset cursor position
        then ;

\G Restore the former contents of the screen and the position of
\G the cursor from memory that is saved there by SAVE-SCREEN and
\G delete the saved data. See also SAVE-SCREEN and RECOVER-SCREEN
: RESTORE-SCREEN        ( -- )                          \ SCREENSV
        saved                                           \ only when saved
        if      savedscreens decr                       \ prepare for previous
                savedscreens @+ cells + @ dup
                0 sbase 0 screensize cmovex             \ move data
                dealloc throw                           \ discard data
                saved savedpositions []double 2@ at-xy  \ reset cursor position
        then ;

deprive

forth definitions

                            \ (* End of Source *) /
