\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Quicksort 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -quicksort

vector qs_compare
vector qs_comparand
vector qs_save
vector qs_get
vector qs_put

: quick
        recursive 2dup + 2/ qs_get qs_save 2dup
        begin   swap
                begin   dup qs_get qs_comparand qs_compare
                while   1+
                repeat
                swap
                begin   dup>r qs_comparand r> qs_get qs_compare
                while   1-
                repeat
                2dup <
                if      2>r r@ qs_get r' qs_get r@ qs_put r' qs_put 2r>
                then
                2dup > 0=
                if      1- swap 1+ swap
                then
                2dup >
        until
        swap rot 2dup <
        if      quick
        else    2drop
        then
        2dup <
        if      quick
        else    2drop
        then ;

                            \ (* End of Source *) /
