\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's
\ DESCRIPTION : Setup for the PROJECT command
\ CATEGORY    : Configuration
\ AUTHORS     : Marcel Hendrix, Albert van der Horst
\ LAST CHANGE : November 14, 1994, Coos Haak
\ LAST CHANGE : April 25, 1994, Coos Haak
\ ----------------------------------------------------------------------



        NEEDS -outfile


        MARKER -project



\ The following assignment of strings is now done CHFORTH.CFG
\ -----------------------------------------------------------------------
\ The three strings proj$, cat$ and creat$ are what you can customize
\ Maximum length: 54 characters.
\ CREATE proj$                          private
\       ", CHForth, a Dutch public domain ANS Forth for PC's"
\ CREATE cat$                           private
\       ", Standard Programs"
\ CREATE creat$                         private
\       ", Coos Haak"
\       ---1--------10--------20--------30--------40--------50---

create prog$                            private \ name of the file
        here #68 dup allot erase

: fspaces               ( n -- )                \ write a number of spaces
        0
        ?do     bl femit
        loop
        ;  private

\ The convention we adopted for the MARKER word is the file name preceeded
\ by a `-' sign. We prefer the name in lower case, and of course the file
\ extension is stripped of.

: fmarker                                       \ write the marker name
        0
        ?do     count dup '.' =                 \ until '.'
                if      drop leave
                then
                dup 'A' [ 'Z' 1+ ] literal within
                if      bl +                    \ lower case
                then
                femit                           \ write character
        loop
        drop
        ;  private

\ Albert's Uniform Header

: bar                   ( -- )                  \ write a line of dashes
        s" \ " ftype #70 0                      \ start a comment
        do      '-' femit                       \ dashes
        loop
        fcr                                     \ new line
        ;  private

: identification        ( -- )
        bar
        s" \ LANGUAGE    : ANS Forth"           ftype fcr
        s" \ PROJECT     : " ftype proj$ count  ftype fcr
        s" \ DESCRIPTION : ??????????"          ftype fcr
        s" \ CATEGORY    : " ftype cat$ count   ftype fcr
        s" \ AUTHOR      : " ftype creat$ count ftype fcr
        s" \ LAST CHANGE : " ftype (date) ftype
               s" , " ftype creat$ count        ftype fcr
        bar
        ;  private

\ Layout of the file

: write-all             ( -- )
        identification fcr fcr fcr
        s"         ?DEF -" ftype prog$ count fmarker
        s"  [IF] -" ftype prog$ count fmarker
        s"  [THEN]" ftype fcr fcr fcr
        s"         MARKER -" ftype prog$ count fmarker
        fcr fcr fcr fcr fcr fcr fcr
        s" \ (* End of Source *) /" #80 over - 2/ fspaces ftype fcr
        ;  private

\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a text file for name with the default extension in FEXT$ .
\G Write a header as defined in the strings PROJ$ CAT$ and CREAT$
\G and start the editor with the cursor at a place where the
\G programmer can start typing. This file can be loaded directly
\G after editing by typing IN . After the header is a MARKER for
\G an automatic FORGET when reloading the file.
: PROJECT              ( "name" -- )            \ PROJECT
        getname prog$ pack                      \ get file name
        count file-status nip 0=
        abort" the file already exists"         \ no need for new file
        prog$ count fopen                       \ make the file
        write-all                               \ write the file
        fclose                                  \ and close it
        s" #18 ,EDIT" evaluate                  \ jump to editor, line 18
        ;

deprive

                            \ (* End of Source *) /
