\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Miscellaneous definitions 
\ CATEGORY    : Compatibility with iForth
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -environ
        NEEDS -stack

        NEEDS -revisions

        MARKER -miscutil



DOC
   Adaptation of CHForth to iForth
ENDDOC

INTERNAL ALSO FORTH

        REVISION -terminal " Terminal module is empty..       "

: SCAN-CHAR     ( char -- )
        BEGIN   DUP PARSE + SOURCE + 1- MIN C@ OVER <>
        WHILE   >IN @ #TIB @ =
                IF      REFILL INVERT #-58 ?ERROR
                THEN
        REPEAT
        DROP
        ;

: :ABOUT
        S" : (ABOUT)" EVALUATE
        ;

: .ABOUT
        S" (ABOUT)" EVALUATE FROM #TIB TO >IN
        ;

' CONSTANT ALIAS =:
' 2CONSTANT ALIAS ==:

: >=
        < invert ;

: <=
        > invert ;


' THROW ALIAS ?FILE

' CLEAR ALIAS 0TO       IMMEDIATE

' PAGE ALIAS CLS
' page alias dark

' DP ALIAS CP

PRIVATES

: (?ERROR")
        INLINE$ ROT
        IF      CR TYPESTRING THROW
        THEN
        2DROP
        ;  PRIVATE

INTERNAL

: ?ERROR"       ( x1 x2 ccc<"> -- )
        POSTPONE (?ERROR") L",
        ;  IMMEDIATE  COMPILE-ONLY

FORTH

DEPRIVE

: ?s
        1 <>
        IF      's' EMIT
        THEN ;

: .$
        COUNT TYPE ;

' NOOP ALIAS EXEC;      IMMEDIATE COMPILE-ONLY

' POSTPONE ALIAS COMPILE        IMMEDIATE COMPILE-ONLY

' NOOP ALIAS -OPT       IMMEDIATE

: 2^X
        1 SWAP LSHIFT ;

: >GRAPHIC
        DUP BL <
        IF      DROP '.'
        THEN ;

: EVAL"
        POSTPONE S" POSTPONE EVALUATE ;
        IMMEDIATE COMPILE-ONLY

: $CONSTANT
        create  here pack c@ 1+ allot
        does>   count ;

: @EXECUTE
        @ execute ;

$4800 =: --^
$4B00 =: <--
$4D00 =: -->
$5000 =: --v

: DLSHIFT
        0
        ?do     d2*
        loop ;

: DRSHIFT
        0
        ?do     d2/ $7FFF and
        loop ;

: register
        drop 0 value ;

' HIDE-CURSOR ALIAS CUROFF
' SHOW-CURSOR ALIAS CURON
^[ constant ESC
' adr alias 'of immediate
' stop? alias wait?

: ;P
        POSTPONE ; PRIVATE
        ;  IMMEDIATE

: DEC.
        .DEC
        ;

: <WORD>
        PARSE-WORD
        ;

: /*
        BEGIN   BL PARSE-WORD S" */" COMPARE
        WHILE   >IN @ #TIB @ =
                IF      REFILL INVERT #-58 ?ERROR
                THEN
        REPEAT
        ;  IMMEDIATE

: 2-
        2 - ;

: 2+
        2 + ;

: EOS
        0 L/SCR 1- AT-XY CR
        ;

' VECTOR ALIAS DEFER

-2 SET-ORDER DEFINITIONS

                            \ (* End of Source *) /
